<?php $__env->startSection('title', __( 'lang_v1.view_user' )); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1><?php echo app('translator')->getFromJson( 'lang_v1.view_user' ); ?></h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-4 col-xs-12">
                <?php echo Form::select('user_id', $users, $user->id , ['class' => 'form-control select2', 'id' => 'user_id']);; ?>

            </div>
        </div>
        <br>
        <div class="row">
            <div class="col-md-12">
                <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs nav-justified">
                        <li class="active">
                            <a href="#user_info_tab" data-toggle="tab" aria-expanded="true"><i class="fas fa-user" aria-hidden="true"></i> <?php echo app('translator')->getFromJson( 'lang_v1.user_info'); ?></a>
                        </li>
                        
                        <li>
                            <a href="#documents_and_notes_tab" data-toggle="tab" aria-expanded="true"><i class="fas fa-paperclip" aria-hidden="true"></i> <?php echo app('translator')->getFromJson('lang_v1.documents_and_notes'); ?></a>
                        </li>
                    </ul>

                    <div class="tab-content">
                        <div class="tab-pane active" id="user_info_tab">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="col-md-12">
                                        <h3 class="profile-username"><?php echo e($user->user_full_name, false); ?></h3>
                                    </div>
                                    <div class="col-md-6">
                                        <p><strong><?php echo app('translator')->getFromJson( 'business.email' ); ?>: </strong> <?php echo e($user->email, false); ?></p>
                                        <p><strong><?php echo app('translator')->getFromJson( 'user.role' ); ?>: </strong> <?php echo e($user->role_name, false); ?></p>
                                        <p><strong><?php echo app('translator')->getFromJson( 'business.username' ); ?>: </strong> <?php echo e($user->username, false); ?></p>
                                    </div>
                                    <div class="col-md-6">
                                        <p><strong><?php echo app('translator')->getFromJson( 'lang_v1.cmmsn_percent' ); ?>: </strong> <?php echo e($user->cmmsn_percent, false); ?>%</p>
                                        <p><?php if($user->status == 'active'): ?> <span class="label label-success"><?php echo app('translator')->getFromJson('business.is_active'); ?></span> <?php else: ?> <span class="label label-danger"><?php echo app('translator')->getFromJson('business.inactive'); ?></span> <?php endif; ?></p>
                                        <p><strong><?php echo app('translator')->getFromJson( 'lang_v1.cmmsn_percent' ); ?>: </strong> <?php echo e($user->cmmsn_percent, false); ?>%</p>
                                        <?php
                                            $selected_contacts = ''
                                        ?>
                                        <?php if(count($user->contactAccess)): ?> 
                                            <?php
                                                $selected_contacts_array = [];
                                            ?>
                                            <?php $__currentLoopData = $user->contactAccess; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                                <?php
                                                    $selected_contacts_array[] = $contact->name; 
                                                ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                                            <?php
                                                $selected_contacts = implode(', ', $selected_contacts_array);
                                            ?>
                                        <?php else: ?> 
                                            <?php
                                                $selected_contacts = __('lang_v1.all'); 
                                            ?>
                                        <?php endif; ?>
                                        <p><strong><?php echo app('translator')->getFromJson( 'lang_v1.allowed_contacts' ); ?>: </strong> <?php echo e($selected_contacts, false); ?></p>
                                    </div>
                                </div>
                            </div>
                            <?php echo $__env->make('user.show_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="tab-pane" id="documents_and_notes_tab">
                            <!-- model id like project_id, user_id -->
                            <input type="hidden" name="notable_id" id="notable_id" value="<?php echo e($user->id, false); ?>">
                            <!-- model name like App\User -->
                            <input type="hidden" name="notable_type" id="notable_type" value="App\User">
                            <div class="document_note_body">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <!-- document & note.js -->
    <?php echo $__env->make('documents_and_notes.document_and_note_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script type="text/javascript">
        $(document).ready( function(){
            $('#user_id').change( function() {
                if ($(this).val()) {
                    window.location = "<?php echo e(url('/users'), false); ?>/" + $(this).val();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lantiiis/mauzo.lantana-events.com/resources/views/manage_user/show.blade.php ENDPATH**/ ?>