/*
 Highmaps JS v8.0.0 (2019-12-10)

 Highmaps as a plugin for Highcharts or Highstock.

 (c) 2011-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(g){"object"===typeof module&&module.exports?(g["default"]=g,module.exports=g):"function"===typeof define&&define.amd?define("highcharts/modules/map",["highcharts"],function(y){g(y);g.Highcharts=y;return g}):g("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(g){function y(a,b,g,p){a.hasOwnProperty(b)||(a[b]=p.apply(null,g))}g=g?g._modules:{};y(g,"parts-map/MapAxis.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(a,b){var g=b.pick;b=a.addEvent;a=a.Axis;b(a,"getSeriesExtremes",
function(){var a=[];this.isXAxis&&(this.series.forEach(function(k,b){k.useMapGeometry&&(a[b]=k.xData,k.xData=[])}),this.seriesXData=a)});b(a,"afterGetSeriesExtremes",function(){var a=this.seriesXData,k;if(this.isXAxis){var b=g(this.dataMin,Number.MAX_VALUE);var r=g(this.dataMax,-Number.MAX_VALUE);this.series.forEach(function(u,l){u.useMapGeometry&&(b=Math.min(b,g(u.minX,b)),r=Math.max(r,g(u.maxX,r)),u.xData=a[l],k=!0)});k&&(this.dataMin=b,this.dataMax=r);delete this.seriesXData}});b(a,"afterSetAxisTranslation",
function(){var a=this.chart;var k=a.plotWidth/a.plotHeight;a=a.xAxis[0];var b;"yAxis"===this.coll&&"undefined"!==typeof a.transA&&this.series.forEach(function(a){a.preserveAspectRatio&&(b=!0)});if(b&&(this.transA=a.transA=Math.min(this.transA,a.transA),k/=(a.max-a.min)/(this.max-this.min),k=1>k?this:a,a=(k.max-k.min)*k.transA,k.pixelPadding=k.len-a,k.minPixelPadding=k.pixelPadding/2,a=k.fixTo)){a=a[1]-k.toValue(a[0],!0);a*=k.transA;if(Math.abs(a)>k.minPixelPadding||k.min===k.dataMin&&k.max===k.dataMax)a=
0;k.minPixelPadding-=a}});b(a,"render",function(){this.fixTo=null})});y(g,"parts-map/ColorSeriesMixin.js",[g["parts/Globals.js"]],function(a){a.colorPointMixin={setVisible:function(a){var b=this,g=a?"show":"hide";b.visible=b.options.visible=!!a;["graphic","dataLabel"].forEach(function(a){if(b[a])b[a][g]()})}};a.colorSeriesMixin={optionalAxis:"colorAxis",colorAxis:0,translateColors:function(){var a=this,g=this.options.nullColor,p=this.colorAxis,k=this.colorKey;(this.data.length?this.data:this.points).forEach(function(b){var u=
b[k];if(u=b.options.color||(b.isNull?g:p&&"undefined"!==typeof u?p.toColor(u,b):b.color||a.color))b.color=u})}}});y(g,"parts-map/ColorAxis.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(a,b){var g=b.erase,p=b.extend,k=b.isNumber,u=b.pick,r=b.splat;b=a.addEvent;var w=a.Axis,l=a.Chart,h=a.Series,e=a.Point,m=a.color,t=a.Legend,x=a.LegendSymbolMixin,v=a.colorPointMixin,f=a.noop,c=a.merge;p(h.prototype,a.colorSeriesMixin);p(e.prototype,v);l.prototype.collectionsWithUpdate.push("colorAxis");
l.prototype.collectionsWithInit.colorAxis=[l.prototype.addColorAxis];var d=a.ColorAxis=function(){this.init.apply(this,arguments)};p(d.prototype,w.prototype);p(d.prototype,{defaultColorAxisOptions:{lineWidth:0,minPadding:0,maxPadding:0,gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:"#999999"},labels:{overflow:"justify",rotation:0},minColor:"#e6ebf5",maxColor:"#003399",tickLength:5,showInLegend:!0},keepProps:["legendGroup",
"legendItemHeight","legendItemWidth","legendItem","legendSymbol"].concat(w.prototype.keepProps),init:function(c,q){this.coll="colorAxis";var n=this.buildOptions.call(c,this.defaultColorAxisOptions,q);w.prototype.init.call(this,c,n);q.dataClasses&&this.initDataClasses(q);this.initStops();this.horiz=!n.opposite;this.zoomEnabled=!1;this.defaultLegendLength=200},initDataClasses:function(n){var q=this.chart,d,f=0,a=q.options.chart.colorCount,e=this.options,b=n.dataClasses.length;this.dataClasses=d=[];
this.legendItems=[];n.dataClasses.forEach(function(n,z){n=c(n);d.push(n);if(q.styledMode||!n.color)"category"===e.dataClassColor?(q.styledMode||(z=q.options.colors,a=z.length,n.color=z[f]),n.colorIndex=f,f++,f===a&&(f=0)):n.color=m(e.minColor).tweenTo(m(e.maxColor),2>b?.5:z/(b-1))})},hasData:function(){return!(!this.tickPositions||!this.tickPositions.length)},setTickPositions:function(){if(!this.dataClasses)return w.prototype.setTickPositions.call(this)},initStops:function(){this.stops=this.options.stops||
[[0,this.options.minColor],[1,this.options.maxColor]];this.stops.forEach(function(c){c.color=m(c[1])})},buildOptions:function(n,q){var d=this.options.legend,f=q.layout?"vertical"!==q.layout:"vertical"!==d.layout;return c(n,{side:f?2:1,reversed:!f},q,{opposite:!f,showEmpty:!1,title:null,visible:d.enabled&&(q?!1!==q.visible:!0)})},setOptions:function(c){w.prototype.setOptions.call(this,c);this.options.crosshair=this.options.marker},setAxisSize:function(){var c=this.legendSymbol,q=this.chart,d=q.options.legend||
{},f,a;c?(this.left=d=c.attr("x"),this.top=f=c.attr("y"),this.width=a=c.attr("width"),this.height=c=c.attr("height"),this.right=q.chartWidth-d-a,this.bottom=q.chartHeight-f-c,this.len=this.horiz?a:c,this.pos=this.horiz?d:f):this.len=(this.horiz?d.symbolWidth:d.symbolHeight)||this.defaultLegendLength},normalizedValue:function(c){this.isLog&&(c=this.val2lin(c));return 1-(this.max-c)/(this.max-this.min||1)},toColor:function(c,q){var d=this.stops,f=this.dataClasses,n;if(f)for(n=f.length;n--;){var a=f[n];
var e=a.from;d=a.to;if(("undefined"===typeof e||c>=e)&&("undefined"===typeof d||c<=d)){var b=a.color;q&&(q.dataClass=n,q.colorIndex=a.colorIndex);break}}else{c=this.normalizedValue(c);for(n=d.length;n--&&!(c>d[n][0]););e=d[n]||d[n+1];d=d[n+1]||e;c=1-(d[0]-c)/(d[0]-e[0]||1);b=e.color.tweenTo(d.color,c)}return b},getOffset:function(){var c=this.legendGroup,d=this.chart.axisOffset[this.side];c&&(this.axisParent=c,w.prototype.getOffset.call(this),this.added||(this.added=!0,this.labelLeft=0,this.labelRight=
this.width),this.chart.axisOffset[this.side]=d)},setLegendColor:function(){var c=this.reversed;var d=c?1:0;c=c?0:1;d=this.horiz?[d,0,c,0]:[0,c,0,d];this.legendColor={linearGradient:{x1:d[0],y1:d[1],x2:d[2],y2:d[3]},stops:this.stops}},drawLegendSymbol:function(c,d){var q=c.padding,f=c.options,n=this.horiz,a=u(f.symbolWidth,n?this.defaultLegendLength:12),e=u(f.symbolHeight,n?12:this.defaultLegendLength),b=u(f.labelPadding,n?16:30);f=u(f.itemDistance,10);this.setLegendColor();d.legendSymbol=this.chart.renderer.rect(0,
c.baseline-11,a,e).attr({zIndex:1}).add(d.legendGroup);this.legendItemWidth=a+q+(n?f:b);this.legendItemHeight=e+q+(n?b:0)},setState:function(c){this.series.forEach(function(d){d.setState(c)})},visible:!0,setVisible:f,getSeriesExtremes:function(){var c=this.series,d=c.length,f;this.dataMin=Infinity;for(this.dataMax=-Infinity;d--;){var a=c[d];var e=a.colorKey=u(a.options.colorKey,a.colorKey,a.pointValKey,a.zoneAxis,"y");var b=a.pointArrayMap;var m=a[e+"Min"]&&a[e+"Max"];if(a[e+"Data"])var k=a[e+"Data"];
else if(b){k=[];b=b.indexOf(e);var t=a.yData;if(0<=b&&t)for(f=0;f<t.length;f++)k.push(u(t[f][b],t[f]))}else k=a.yData;m?(a.minColorValue=a[e+"Min"],a.maxColorValue=a[e+"Max"]):(h.prototype.getExtremes.call(a,k),a.minColorValue=a.dataMin,a.maxColorValue=a.dataMax);"undefined"!==typeof a.minColorValue&&(this.dataMin=Math.min(this.dataMin,a.minColorValue),this.dataMax=Math.max(this.dataMax,a.maxColorValue));m||h.prototype.getExtremes.call(a)}},drawCrosshair:function(c,d){var f=d&&d.plotX,a=d&&d.plotY,
q=this.pos,n=this.len;if(d){var e=this.toPixels(d[d.series.colorKey]);e<q?e=q-2:e>q+n&&(e=q+n+2);d.plotX=e;d.plotY=this.len-e;w.prototype.drawCrosshair.call(this,c,d);d.plotX=f;d.plotY=a;this.cross&&!this.cross.addedToColorAxis&&this.legendGroup&&(this.cross.addClass("highcharts-coloraxis-marker").add(this.legendGroup),this.cross.addedToColorAxis=!0,this.chart.styledMode||this.cross.attr({fill:this.crosshair.color}))}},getPlotLinePath:function(c){var d=c.translatedValue;return k(d)?this.horiz?["M",
d-4,this.top-6,"L",d+4,this.top-6,d,this.top,"Z"]:["M",this.left,d,"L",this.left-6,d+6,this.left-6,d-6,"Z"]:w.prototype.getPlotLinePath.apply(this,arguments)},update:function(d,f){var a=this.chart,n=a.legend,q=this.buildOptions.call(a,{},d);this.series.forEach(function(c){c.isDirtyData=!0});(d.dataClasses&&n.allItems||this.dataClasses)&&this.destroyItems();a.options[this.coll]=c(this.userOptions,q);w.prototype.update.call(this,q,f);this.legendItem&&(this.setLegendColor(),n.colorizeItem(this,!0))},
destroyItems:function(){var c=this.chart;this.legendItem?c.legend.destroyItem(this):this.legendItems&&this.legendItems.forEach(function(d){c.legend.destroyItem(d)});c.isDirtyLegend=!0},remove:function(c){this.destroyItems();w.prototype.remove.call(this,c)},getDataClassLegendSymbols:function(){var c=this,d=this.chart,a=this.legendItems,e=d.options.legend,b=e.valueDecimals,m=e.valueSuffix||"",k;a.length||this.dataClasses.forEach(function(q,n){var e=!0,z=q.from,t=q.to,h=d.numberFormatter;k="";"undefined"===
typeof z?k="< ":"undefined"===typeof t&&(k="> ");"undefined"!==typeof z&&(k+=h(z,b)+m);"undefined"!==typeof z&&"undefined"!==typeof t&&(k+=" - ");"undefined"!==typeof t&&(k+=h(t,b)+m);a.push(p({chart:d,name:k,options:{},drawLegendSymbol:x.drawRectangle,visible:!0,setState:f,isDataClass:!0,setVisible:function(){e=this.visible=!e;c.series.forEach(function(c){c.points.forEach(function(c){c.dataClass===n&&c.setVisible(e)})});d.legend.colorizeItem(this,e)}},q))});return a},beforePadding:!1,name:""});["fill",
"stroke"].forEach(function(c){a.Fx.prototype[c+"Setter"]=function(){this.elem.attr(c,m(this.start).tweenTo(m(this.end),this.pos),null,!0)}});b(l,"afterGetAxes",function(){var c=this,a=c.options;this.colorAxis=[];a.colorAxis&&(a.colorAxis=r(a.colorAxis),a.colorAxis.forEach(function(a,f){a.index=f;new d(c,a)}))});b(h,"bindAxes",function(){var c=this.axisTypes;c?-1===c.indexOf("colorAxis")&&c.push("colorAxis"):this.axisTypes=["colorAxis"]});b(t,"afterGetAllItems",function(c){var d=[],a,f;(this.chart.colorAxis||
[]).forEach(function(f){(a=f.options)&&a.showInLegend&&(a.dataClasses&&a.visible?d=d.concat(f.getDataClassLegendSymbols()):a.visible&&d.push(f),f.series.forEach(function(d){if(!d.options.showInLegend||a.dataClasses)"point"===d.options.legendType?d.points.forEach(function(d){g(c.allItems,d)}):g(c.allItems,d)}))});for(f=d.length;f--;)c.allItems.unshift(d[f])});b(t,"afterColorizeItem",function(c){c.visible&&c.item.legendColor&&c.item.legendSymbol.attr({fill:c.item.legendColor})});b(t,"afterUpdate",function(){var c=
this.chart.colorAxis;c&&c.forEach(function(c,d,a){c.update({},a)})});b(h,"afterTranslate",function(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()})});y(g,"parts-map/ColorMapSeriesMixin.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(a,b){var g=b.defined;b=a.noop;var p=a.seriesTypes;a.colorMapPointMixin={dataLabelOnNull:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value},setState:function(b){a.Point.prototype.setState.call(this,
b);this.graphic&&this.graphic.attr({zIndex:"hover"===b?1:0})}};a.colorMapSeriesMixin={pointArrayMap:["value"],axisTypes:["xAxis","yAxis","colorAxis"],trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:b,parallelArrays:["x","y","value"],colorKey:"value",pointAttribs:p.column.prototype.pointAttribs,colorAttribs:function(a){var b={};g(a.color)&&(b[this.colorProp||"fill"]=a.color);return b}}});y(g,"parts-map/MapNavigation.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(a,b){function g(a){a&&
(a.preventDefault&&a.preventDefault(),a.stopPropagation&&a.stopPropagation(),a.cancelBubble=!0)}function p(a){this.init(a)}var k=b.extend,u=b.objectEach,r=b.pick,w=a.addEvent;b=a.Chart;var l=a.doc,h=a.merge;p.prototype.init=function(a){this.chart=a;a.mapNavButtons=[]};p.prototype.update=function(a){var e=this.chart,b=e.options.mapNavigation,l,v,f,c,d,n=function(c){this.handler.call(e,c);g(c)},q=e.mapNavButtons;a&&(b=e.options.mapNavigation=h(e.options.mapNavigation,a));for(;q.length;)q.pop().destroy();
r(b.enableButtons,b.enabled)&&!e.renderer.forExport&&u(b.buttons,function(a,m){l=h(b.buttonOptions,a);e.styledMode||(v=l.theme,v.style=h(l.theme.style,l.style),c=(f=v.states)&&f.hover,d=f&&f.select);a=e.renderer.button(l.text,0,0,n,v,c,d,0,"zoomIn"===m?"topbutton":"bottombutton").addClass("highcharts-map-navigation highcharts-"+{zoomIn:"zoom-in",zoomOut:"zoom-out"}[m]).attr({width:l.width,height:l.height,title:e.options.lang[m],padding:l.padding,zIndex:5}).add();a.handler=l.onclick;a.align(k(l,{width:a.width,
height:2*a.height}),null,l.alignTo);w(a.element,"dblclick",g);q.push(a)});this.updateEvents(b)};p.prototype.updateEvents=function(a){var e=this.chart;r(a.enableDoubleClickZoom,a.enabled)||a.enableDoubleClickZoomTo?this.unbindDblClick=this.unbindDblClick||w(e.container,"dblclick",function(a){e.pointer.onContainerDblClick(a)}):this.unbindDblClick&&(this.unbindDblClick=this.unbindDblClick());r(a.enableMouseWheelZoom,a.enabled)?this.unbindMouseWheel=this.unbindMouseWheel||w(e.container,"undefined"===
typeof l.onmousewheel?"DOMMouseScroll":"mousewheel",function(a){e.pointer.onContainerMouseWheel(a);g(a);return!1}):this.unbindMouseWheel&&(this.unbindMouseWheel=this.unbindMouseWheel())};k(b.prototype,{fitToBox:function(a,b){[["x","width"],["y","height"]].forEach(function(e){var k=e[0];e=e[1];a[k]+a[e]>b[k]+b[e]&&(a[e]>b[e]?(a[e]=b[e],a[k]=b[k]):a[k]=b[k]+b[e]-a[e]);a[e]>b[e]&&(a[e]=b[e]);a[k]<b[k]&&(a[k]=b[k])});return a},mapZoom:function(a,b,k,h,l){var f=this.xAxis[0],c=f.max-f.min,d=r(b,f.min+
c/2),n=c*a;c=this.yAxis[0];var q=c.max-c.min,e=r(k,c.min+q/2);q*=a;d=this.fitToBox({x:d-n*(h?(h-f.pos)/f.len:.5),y:e-q*(l?(l-c.pos)/c.len:.5),width:n,height:q},{x:f.dataMin,y:c.dataMin,width:f.dataMax-f.dataMin,height:c.dataMax-c.dataMin});n=d.x<=f.dataMin&&d.width>=f.dataMax-f.dataMin&&d.y<=c.dataMin&&d.height>=c.dataMax-c.dataMin;h&&(f.fixTo=[h-f.pos,b]);l&&(c.fixTo=[l-c.pos,k]);"undefined"===typeof a||n?(f.setExtremes(void 0,void 0,!1),c.setExtremes(void 0,void 0,!1)):(f.setExtremes(d.x,d.x+d.width,
!1),c.setExtremes(d.y,d.y+d.height,!1));this.redraw()}});w(b,"beforeRender",function(){this.mapNavigation=new p(this);this.mapNavigation.update()});a.MapNavigation=p});y(g,"parts-map/MapPointer.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(a,b){var g=b.extend,p=b.pick;b=b.wrap;a=a.Pointer;g(a.prototype,{onContainerDblClick:function(a){var b=this.chart;a=this.normalize(a);b.options.mapNavigation.enableDoubleClickZoomTo?b.pointer.inClass(a.target,"highcharts-tracker")&&b.hoverPoint&&
b.hoverPoint.zoomTo():b.isInsidePlot(a.chartX-b.plotLeft,a.chartY-b.plotTop)&&b.mapZoom(.5,b.xAxis[0].toValue(a.chartX),b.yAxis[0].toValue(a.chartY),a.chartX,a.chartY)},onContainerMouseWheel:function(a){var b=this.chart;a=this.normalize(a);var k=a.detail||-(a.wheelDelta/120);b.isInsidePlot(a.chartX-b.plotLeft,a.chartY-b.plotTop)&&b.mapZoom(Math.pow(b.options.mapNavigation.mouseWheelSensitivity,k),b.xAxis[0].toValue(a.chartX),b.yAxis[0].toValue(a.chartY),a.chartX,a.chartY)}});b(a.prototype,"zoomOption",
function(a){var b=this.chart.options.mapNavigation;p(b.enableTouchZoom,b.enabled)&&(this.chart.options.chart.pinchType="xy");a.apply(this,[].slice.call(arguments,1))});b(a.prototype,"pinchTranslate",function(a,b,g,p,l,h,e){a.call(this,b,g,p,l,h,e);"map"===this.chart.options.chart.type&&this.hasZoom&&(a=p.scaleX>p.scaleY,this.pinchTranslateDirection(!a,b,g,p,l,h,e,a?p.scaleX:p.scaleY))})});y(g,"parts-map/MapSeries.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(a,b){var g=b.extend,p=b.isArray,
k=b.isNumber,u=b.objectEach,r=b.pick,w=b.splat;b=a.colorMapPointMixin;var l=a.merge,h=a.noop,e=a.fireEvent,m=a.Point,t=a.Series,x=a.seriesType,v=a.seriesTypes;x("map","scatter",{animation:!1,dataLabels:{crop:!1,formatter:function(){return this.point.value},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},marker:null,nullColor:"#f7f7f7",stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:"{point.name}: {point.value}<br/>"},turboThreshold:0,allAreas:!0,borderColor:"#cccccc",borderWidth:1,
joinBy:"hc-key",states:{hover:{halo:null,brightness:.2},normal:{animation:!0},select:{color:"#cccccc"},inactive:{opacity:1}}},l(a.colorMapSeriesMixin,{type:"map",getExtremesFromAll:!0,useMapGeometry:!0,forceDL:!0,searchPoint:h,directTouch:!0,preserveAspectRatio:!0,pointArrayMap:["value"],setOptions:function(a){a=t.prototype.setOptions.call(this,a);var c=a.joinBy;null===c&&(c="_i");c=this.joinBy=w(c);c[1]||(c[1]=c[0]);return a},getBox:function(f){var c=Number.MAX_VALUE,d=-c,b=c,q=-c,e=c,h=c,m=this.xAxis,
l=this.yAxis,t;(f||[]).forEach(function(f){if(f.path){"string"===typeof f.path&&(f.path=a.splitPath(f.path));var n=f.path||[],m=n.length,l=!1,z=-c,g=c,B=-c,A=c,C=f.properties;if(!f._foundBox){for(;m--;)k(n[m])&&(l?(z=Math.max(z,n[m]),g=Math.min(g,n[m])):(B=Math.max(B,n[m]),A=Math.min(A,n[m])),l=!l);f._midX=g+(z-g)*r(f.middleX,C&&C["hc-middle-x"],.5);f._midY=A+(B-A)*r(f.middleY,C&&C["hc-middle-y"],.5);f._maxX=z;f._minX=g;f._maxY=B;f._minY=A;f.labelrank=r(f.labelrank,(z-g)*(B-A));f._foundBox=!0}d=Math.max(d,
f._maxX);b=Math.min(b,f._minX);q=Math.max(q,f._maxY);e=Math.min(e,f._minY);h=Math.min(f._maxX-f._minX,f._maxY-f._minY,h);t=!0}});t&&(this.minY=Math.min(e,r(this.minY,c)),this.maxY=Math.max(q,r(this.maxY,-c)),this.minX=Math.min(b,r(this.minX,c)),this.maxX=Math.max(d,r(this.maxX,-c)),m&&"undefined"===typeof m.options.minRange&&(m.minRange=Math.min(5*h,(this.maxX-this.minX)/5,m.minRange||c)),l&&"undefined"===typeof l.options.minRange&&(l.minRange=Math.min(5*h,(this.maxY-this.minY)/5,l.minRange||c)))},
hasData:function(){return!!this.processedXData.length},getExtremes:function(){t.prototype.getExtremes.call(this,this.valueData);this.chart.hasRendered&&this.isDirtyData&&this.getBox(this.options.data);this.valueMin=this.dataMin;this.valueMax=this.dataMax;this.dataMin=this.minY;this.dataMax=this.maxY},translatePath:function(a){var c=!1,d=this.xAxis,f=this.yAxis,b=d.min,e=d.transA;d=d.minPixelPadding;var h=f.min,m=f.transA;f=f.minPixelPadding;var l,g=[];if(a)for(l=a.length;l--;)k(a[l])?(g[l]=c?(a[l]-
b)*e+d:(a[l]-h)*m+f,c=!c):g[l]=a[l];return g},setData:function(f,c,d,b){var q=this.options,e=this.chart.options.chart,n=e&&e.map,h=q.mapData,m=this.joinBy,g=q.keys||this.pointArrayMap,v=[],r={},x=this.chart.mapTransforms;!h&&n&&(h="string"===typeof n?a.maps[n]:n);f&&f.forEach(function(c,d){var b=0;if(k(c))f[d]={value:c};else if(p(c)){f[d]={};!q.keys&&c.length>g.length&&"string"===typeof c[0]&&(f[d]["hc-key"]=c[0],++b);for(var e=0;e<g.length;++e,++b)g[e]&&"undefined"!==typeof c[b]&&(0<g[e].indexOf(".")?
a.Point.prototype.setNestedProperty(f[d],c[b],g[e]):f[d][g[e]]=c[b])}m&&"_i"===m[0]&&(f[d]._i=d)});this.getBox(f);(this.chart.mapTransforms=x=e&&e.mapTransforms||h&&h["hc-transform"]||x)&&u(x,function(c){c.rotation&&(c.cosAngle=Math.cos(c.rotation),c.sinAngle=Math.sin(c.rotation))});if(h){"FeatureCollection"===h.type&&(this.mapTitle=h.title,h=a.geojson(h,this.type,this));this.mapData=h;this.mapMap={};for(x=0;x<h.length;x++)e=h[x],n=e.properties,e._i=x,m[0]&&n&&n[m[0]]&&(e[m[0]]=n[m[0]]),r[e[m[0]]]=
e;this.mapMap=r;f&&m[1]&&f.forEach(function(c){r[c[m[1]]]&&v.push(r[c[m[1]]])});q.allAreas?(this.getBox(h),f=f||[],m[1]&&f.forEach(function(c){v.push(c[m[1]])}),v="|"+v.map(function(c){return c&&c[m[0]]}).join("|")+"|",h.forEach(function(c){m[0]&&-1!==v.indexOf("|"+c[m[0]]+"|")||(f.push(l(c,{value:null})),b=!1)})):this.getBox(v)}t.prototype.setData.call(this,f,c,d,b)},drawGraph:h,drawDataLabels:h,doFullTranslate:function(){return this.isDirtyData||this.chart.isResizing||this.chart.renderer.isVML||
!this.baseTrans},translate:function(){var a=this,c=a.xAxis,d=a.yAxis,b=a.doFullTranslate();a.generatePoints();a.data.forEach(function(f){k(f._midX)&&k(f._midY)&&(f.plotX=c.toPixels(f._midX,!0),f.plotY=d.toPixels(f._midY,!0));b&&(f.shapeType="path",f.shapeArgs={d:a.translatePath(f.path)})});e(a,"afterTranslate")},pointAttribs:function(a,c){c=a.series.chart.styledMode?this.colorAttribs(a):v.column.prototype.pointAttribs.call(this,a,c);c["stroke-width"]=r(a.options[this.pointAttrToOptions&&this.pointAttrToOptions["stroke-width"]||
"borderWidth"],"inherit");return c},drawPoints:function(){var a=this,c=a.xAxis,d=a.yAxis,b=a.group,e=a.chart,h=e.renderer,m=this.baseTrans;a.transformGroup||(a.transformGroup=h.g().attr({scaleX:1,scaleY:1}).add(b),a.transformGroup.survive=!0);if(a.doFullTranslate())e.hasRendered&&!e.styledMode&&a.points.forEach(function(c){c.shapeArgs&&(c.shapeArgs.fill=a.pointAttribs(c,c.state).fill)}),a.group=a.transformGroup,v.column.prototype.drawPoints.apply(a),a.group=b,a.points.forEach(function(c){if(c.graphic){var d=
"";c.name&&(d+="highcharts-name-"+c.name.replace(/ /g,"-").toLowerCase());c.properties&&c.properties["hc-key"]&&(d+=" highcharts-key-"+c.properties["hc-key"].toLowerCase());d&&c.graphic.addClass(d);e.styledMode&&c.graphic.css(a.pointAttribs(c,c.selected&&"select"||void 0))}}),this.baseTrans={originX:c.min-c.minPixelPadding/c.transA,originY:d.min-d.minPixelPadding/d.transA+(d.reversed?0:d.len/d.transA),transAX:c.transA,transAY:d.transA},this.transformGroup.animate({translateX:0,translateY:0,scaleX:1,
scaleY:1});else{var l=c.transA/m.transAX;var k=d.transA/m.transAY;var g=c.toPixels(m.originX,!0);var t=d.toPixels(m.originY,!0);.99<l&&1.01>l&&.99<k&&1.01>k&&(k=l=1,g=Math.round(g),t=Math.round(t));var p=this.transformGroup;if(e.renderer.globalAnimation){var x=p.attr("translateX");var u=p.attr("translateY");var w=p.attr("scaleX");var G=p.attr("scaleY");p.attr({animator:0}).animate({animator:1},{step:function(c,a){p.attr({translateX:x+(g-x)*a.pos,translateY:u+(t-u)*a.pos,scaleX:w+(l-w)*a.pos,scaleY:G+
(k-G)*a.pos})}})}else p.attr({translateX:g,translateY:t,scaleX:l,scaleY:k})}e.styledMode||b.element.setAttribute("stroke-width",r(a.options[a.pointAttrToOptions&&a.pointAttrToOptions["stroke-width"]||"borderWidth"],1)/(l||1));this.drawMapDataLabels()},drawMapDataLabels:function(){t.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)},render:function(){var a=this,c=t.prototype.render;a.chart.renderer.isVML&&3E3<a.data.length?setTimeout(function(){c.call(a)}):
c.call(a)},animate:function(a){var c=this.options.animation,d=this.group,f=this.xAxis,b=this.yAxis,e=f.pos,h=b.pos;this.chart.renderer.isSVG&&(!0===c&&(c={duration:1E3}),a?d.attr({translateX:e+f.len/2,translateY:h+b.len/2,scaleX:.001,scaleY:.001}):(d.animate({translateX:e,translateY:h,scaleX:1,scaleY:1},c),this.animate=null))},animateDrilldown:function(a){var c=this.chart.plotBox,d=this.chart.drilldownLevels[this.chart.drilldownLevels.length-1],f=d.bBox,b=this.chart.options.drilldown.animation;a||
(a=Math.min(f.width/c.width,f.height/c.height),d.shapeArgs={scaleX:a,scaleY:a,translateX:f.x,translateY:f.y},this.points.forEach(function(a){a.graphic&&a.graphic.attr(d.shapeArgs).animate({scaleX:1,scaleY:1,translateX:0,translateY:0},b)}),this.animate=null)},drawLegendSymbol:a.LegendSymbolMixin.drawRectangle,animateDrillupFrom:function(a){v.column.prototype.animateDrillupFrom.call(this,a)},animateDrillupTo:function(a){v.column.prototype.animateDrillupTo.call(this,a)}}),g({applyOptions:function(a,
c){var d=this.series;a=m.prototype.applyOptions.call(this,a,c);c=d.joinBy;d.mapData&&((c="undefined"!==typeof a[c[1]]&&d.mapMap[a[c[1]]])?(d.xyFromShape&&(a.x=c._midX,a.y=c._midY),g(a,c)):a.value=a.value||null);return a},onMouseOver:function(b){a.clearTimeout(this.colorInterval);if(null!==this.value||this.series.options.nullInteraction)m.prototype.onMouseOver.call(this,b);else this.series.onMouseOut(b)},zoomTo:function(){var a=this.series;a.xAxis.setExtremes(this._minX,this._maxX,!1);a.yAxis.setExtremes(this._minY,
this._maxY,!1);a.chart.redraw()}},b));""});y(g,"parts-map/MapLineSeries.js",[g["parts/Globals.js"]],function(a){var b=a.seriesType,g=a.seriesTypes;b("mapline","map",{lineWidth:1,fillColor:"none"},{type:"mapline",colorProp:"stroke",pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointAttribs:function(a,b){a=g.map.prototype.pointAttribs.call(this,a,b);a.fill=this.options.fillColor;return a},drawLegendSymbol:g.line.prototype.drawLegendSymbol});""});y(g,"parts-map/MapPointSeries.js",[g["parts/Globals.js"]],
function(a){var b=a.merge,g=a.Point,p=a.Series;a=a.seriesType;a("mappoint","scatter",{dataLabels:{crop:!1,defer:!1,enabled:!0,formatter:function(){return this.point.name},overflow:!1,style:{color:"#000000"}}},{type:"mappoint",forceDL:!0,drawDataLabels:function(){p.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)}},{applyOptions:function(a,p){a="undefined"!==typeof a.lat&&"undefined"!==typeof a.lon?b(a,this.series.chart.fromLatLonToPoint(a)):
a;return g.prototype.applyOptions.call(this,a,p)}});""});y(g,"parts-more/BubbleLegend.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(a,b){var g=b.arrayMax,p=b.arrayMin,k=b.isNumber,u=b.objectEach,r=b.pick;b=b.wrap;var w=a.Series,l=a.Legend,h=a.Chart,e=a.addEvent,m=a.color,t=a.merge,x=a.noop,v=a.stableSort,f=a.setOptions;f({legend:{bubbleLegend:{borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,
enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:10,color:void 0},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0}}});a.BubbleLegend=function(a,d){this.init(a,d)};a.BubbleLegend.prototype={init:function(a,d){this.options=a;this.visible=!0;this.chart=d.chart;this.legend=d},setState:x,addToLegend:function(a){a.splice(this.options.legendIndex,
0,this)},drawLegendSymbol:function(a){var c=this.chart,b=this.options,f=r(a.options.itemDistance,20),e=b.ranges;var h=b.connectorDistance;this.fontMetrics=c.renderer.fontMetrics(b.labels.style.fontSize.toString()+"px");e&&e.length&&k(e[0].value)?(v(e,function(a,c){return c.value-a.value}),this.ranges=e,this.setOptions(),this.render(),c=this.getMaxLabelSize(),e=this.ranges[0].radius,a=2*e,h=h-e+c.width,h=0<h?h:0,this.maxLabel=c,this.movementX="left"===b.labels.align?h:0,this.legendItemWidth=a+h+f,
this.legendItemHeight=a+this.fontMetrics.h/2):a.options.bubbleLegend.autoRanges=!0},setOptions:function(){var a=this.ranges,d=this.options,b=this.chart.series[d.seriesIndex],f=this.legend.baseline,e={"z-index":d.zIndex,"stroke-width":d.borderWidth},h={"z-index":d.zIndex,"stroke-width":d.connectorWidth},l=this.getLabelStyles(),g=b.options.marker.fillOpacity,k=this.chart.styledMode;a.forEach(function(c,q){k||(e.stroke=r(c.borderColor,d.borderColor,b.color),e.fill=r(c.color,d.color,1!==g?m(b.color).setOpacity(g).get("rgba"):
b.color),h.stroke=r(c.connectorColor,d.connectorColor,b.color));a[q].radius=this.getRangeRadius(c.value);a[q]=t(a[q],{center:a[0].radius-a[q].radius+f});k||t(!0,a[q],{bubbleStyle:t(!1,e),connectorStyle:t(!1,h),labelStyle:l})},this)},getLabelStyles:function(){var a=this.options,d={},b="left"===a.labels.align,f=this.legend.options.rtl;u(a.labels.style,function(a,c){"color"!==c&&"fontSize"!==c&&"z-index"!==c&&(d[c]=a)});return t(!1,d,{"font-size":a.labels.style.fontSize,fill:r(a.labels.style.color,"#000000"),
"z-index":a.zIndex,align:f||b?"right":"left"})},getRangeRadius:function(a){var c=this.options;return this.chart.series[this.options.seriesIndex].getRadius.call(this,c.ranges[c.ranges.length-1].value,c.ranges[0].value,c.minSize,c.maxSize,a)},render:function(){var a=this.chart.renderer,d=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]});this.legendSymbol=a.g("bubble-legend");this.legendItem=a.g("bubble-legend-item");this.legendSymbol.translateX=0;this.legendSymbol.translateY=
0;this.ranges.forEach(function(a){a.value>=d&&this.renderRange(a)},this);this.legendSymbol.add(this.legendItem);this.legendItem.add(this.legendGroup);this.hideOverlappingLabels()},renderRange:function(a){var c=this.options,b=c.labels,f=this.chart.renderer,e=this.symbols,h=e.labels,m=a.center,l=Math.abs(a.radius),g=c.connectorDistance,k=b.align,t=b.style.fontSize;g=this.legend.options.rtl||"left"===k?-g:g;b=c.connectorWidth;var v=this.ranges[0].radius,p=m-l-c.borderWidth/2+b/2;t=t/2-(this.fontMetrics.h-
t)/2;var r=f.styledMode;"center"===k&&(g=0,c.connectorDistance=0,a.labelStyle.align="center");k=p+c.labels.y;var x=v+g+c.labels.x;e.bubbleItems.push(f.circle(v,m+((p%1?1:.5)-(b%2?0:.5)),l).attr(r?{}:a.bubbleStyle).addClass((r?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-symbol "+(c.className||"")).add(this.legendSymbol));e.connectors.push(f.path(f.crispLine(["M",v,p,"L",v+g,p],c.connectorWidth)).attr(r?{}:a.connectorStyle).addClass((r?"highcharts-color-"+this.options.seriesIndex+
" ":"")+"highcharts-bubble-legend-connectors "+(c.connectorClassName||"")).add(this.legendSymbol));a=f.text(this.formatLabel(a),x,k+t).attr(r?{}:a.labelStyle).addClass("highcharts-bubble-legend-labels "+(c.labels.className||"")).add(this.legendSymbol);h.push(a);a.placed=!0;a.alignAttr={x:x,y:k+t}},getMaxLabelSize:function(){var a,d;this.symbols.labels.forEach(function(c){d=c.getBBox(!0);a=a?d.width>a.width?d:a:d});return a||{}},formatLabel:function(c){var d=this.options,b=d.labels.formatter;d=d.labels.format;
var f=this.chart.numberFormatter;return d?a.format(d,c):b?b.call(c):f(c.value,1)},hideOverlappingLabels:function(){var a=this.chart,d=this.symbols;!this.options.labels.allowOverlap&&d&&(a.hideOverlappingLabels(d.labels),d.labels.forEach(function(a,c){a.newOpacity?a.newOpacity!==a.oldOpacity&&d.connectors[c].show():d.connectors[c].hide()}))},getRanges:function(){var a=this.legend.bubbleLegend,d=a.options.ranges,b,f=Number.MAX_VALUE,e=-Number.MAX_VALUE;a.chart.series.forEach(function(a){a.isBubble&&
!a.ignoreSeries&&(b=a.zData.filter(k),b.length&&(f=r(a.options.zMin,Math.min(f,Math.max(p(b),!1===a.options.displayNegative?a.options.zThreshold:-Number.MAX_VALUE))),e=r(a.options.zMax,Math.max(e,g(b)))))});var h=f===e?[{value:e}]:[{value:f},{value:(f+e)/2},{value:e,autoRanges:!0}];d.length&&d[0].radius&&h.reverse();h.forEach(function(a,c){d&&d[c]&&(h[c]=t(!1,d[c],a))});return h},predictBubbleSizes:function(){var a=this.chart,d=this.fontMetrics,b=a.legend.options,f="horizontal"===b.layout,e=f?a.legend.lastLineHeight:
0,h=a.plotSizeX,m=a.plotSizeY,g=a.series[this.options.seriesIndex];a=Math.ceil(g.minPxSize);var l=Math.ceil(g.maxPxSize);g=g.options.maxSize;var k=Math.min(m,h);if(b.floating||!/%$/.test(g))d=l;else if(g=parseFloat(g),d=(k+e-d.h/2)*g/100/(g/100+1),f&&m-d>=h||!f&&h-d>=m)d=l;return[a,Math.ceil(d)]},updateRanges:function(a,d){var c=this.legend.options.bubbleLegend;c.minSize=a;c.maxSize=d;c.ranges=this.getRanges()},correctSizes:function(){var a=this.legend,d=this.chart.series[this.options.seriesIndex];
1<Math.abs(Math.ceil(d.maxPxSize)-this.options.maxSize)&&(this.updateRanges(this.options.minSize,d.maxPxSize),a.render())}};e(a.Legend,"afterGetAllItems",function(c){var d=this.bubbleLegend,b=this.options,f=b.bubbleLegend,e=this.chart.getVisibleBubbleSeriesIndex();d&&d.ranges&&d.ranges.length&&(f.ranges.length&&(f.autoRanges=!!f.ranges[0].autoRanges),this.destroyItem(d));0<=e&&b.enabled&&f.enabled&&(f.seriesIndex=e,this.bubbleLegend=new a.BubbleLegend(f,this),this.bubbleLegend.addToLegend(c.allItems))});
h.prototype.getVisibleBubbleSeriesIndex=function(){for(var a=this.series,d=0;d<a.length;){if(a[d]&&a[d].isBubble&&a[d].visible&&a[d].zData.length)return d;d++}return-1};l.prototype.getLinesHeights=function(){var a=this.allItems,d=[],b=a.length,f,e=0;for(f=0;f<b;f++)if(a[f].legendItemHeight&&(a[f].itemHeight=a[f].legendItemHeight),a[f]===a[b-1]||a[f+1]&&a[f]._legendItemPos[1]!==a[f+1]._legendItemPos[1]){d.push({height:0});var h=d[d.length-1];for(e;e<=f;e++)a[e].itemHeight>h.height&&(h.height=a[e].itemHeight);
h.step=f}return d};l.prototype.retranslateItems=function(a){var c,b,f,e=this.options.rtl,h=0;this.allItems.forEach(function(d,m){c=d.legendGroup.translateX;b=d._legendItemPos[1];if((f=d.movementX)||e&&d.ranges)f=e?c-d.options.maxSize/2:c+f,d.legendGroup.attr({translateX:f});m>a[h].step&&h++;d.legendGroup.attr({translateY:Math.round(b+a[h].height/2)});d._legendItemPos[1]=b+a[h].height/2})};e(w,"legendItemClick",function(){var a=this.chart,d=this.visible,b=this.chart.legend;b&&b.bubbleLegend&&(this.visible=
!d,this.ignoreSeries=d,a=0<=a.getVisibleBubbleSeriesIndex(),b.bubbleLegend.visible!==a&&(b.update({bubbleLegend:{enabled:a}}),b.bubbleLegend.visible=a),this.visible=d)});b(h.prototype,"drawChartBox",function(a,d,b){var c=this.legend,f=0<=this.getVisibleBubbleSeriesIndex();if(c&&c.options.enabled&&c.bubbleLegend&&c.options.bubbleLegend.autoRanges&&f){var e=c.bubbleLegend.options;f=c.bubbleLegend.predictBubbleSizes();c.bubbleLegend.updateRanges(f[0],f[1]);e.placed||(c.group.placed=!1,c.allItems.forEach(function(a){a.legendGroup.translateY=
null}));c.render();this.getMargins();this.axes.forEach(function(a){a.visible&&a.render();e.placed||(a.setScale(),a.updateNames(),u(a.ticks,function(a){a.isNew=!0;a.isNewLabel=!0}))});e.placed=!0;this.getMargins();a.call(this,d,b);c.bubbleLegend.correctSizes();c.retranslateItems(c.getLinesHeights())}else a.call(this,d,b),c&&c.options.enabled&&c.bubbleLegend&&(c.render(),c.retranslateItems(c.getLinesHeights()))})});y(g,"parts-more/BubbleSeries.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(a,
b){var g=b.arrayMax,p=b.arrayMin,k=b.clamp,u=b.extend,r=b.isNumber,w=b.pick,l=b.pInt;b=a.Axis;var h=a.color,e=a.noop,m=a.Point,t=a.Series,x=a.seriesType,v=a.seriesTypes;x("bubble","scatter",{dataLabels:{formatter:function(){return this.point.z},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},
turboThreshold:0,zThreshold:0,zoneAxis:"z"},{pointArrayMap:["y","z"],parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",bubblePadding:!0,zoneAxis:"z",directTouch:!0,isBubble:!0,pointAttribs:function(a,c){var d=this.options.marker.fillOpacity;a=t.prototype.pointAttribs.call(this,a,c);1!==d&&(a.fill=h(a.fill).setOpacity(d).get("rgba"));return a},getRadii:function(a,c,d){var b=this.zData,f=this.yData,e=d.minPxSize,h=d.maxPxSize,m=[];var g=0;for(d=b.length;g<d;g++){var l=
b[g];m.push(this.getRadius(a,c,e,h,l,f[g]))}this.radii=m},getRadius:function(a,c,d,b,e,h){var f=this.options,m="width"!==f.sizeBy,g=f.zThreshold,l=c-a,k=.5;if(null===h||null===e)return null;if(r(e)){f.sizeByAbsoluteValue&&(e=Math.abs(e-g),l=Math.max(c-g,Math.abs(a-g)),a=0);if(e<a)return d/2-1;0<l&&(k=(e-a)/l)}m&&0<=k&&(k=Math.sqrt(k));return Math.ceil(d+k*(b-d))/2},animate:function(a){!a&&this.points.length<this.options.animationLimit&&(this.points.forEach(function(a){var c=a.graphic;if(c&&c.width){var b=
{x:c.x,y:c.y,width:c.width,height:c.height};c.attr({x:a.plotX,y:a.plotY,width:1,height:1});c.animate(b,this.options.animation)}},this),this.animate=null)},hasData:function(){return!!this.processedXData.length},translate:function(){var a,c=this.data,d=this.radii;v.scatter.prototype.translate.call(this);for(a=c.length;a--;){var b=c[a];var e=d?d[a]:0;r(e)&&e>=this.minPxSize/2?(b.marker=u(b.marker,{radius:e,width:2*e,height:2*e}),b.dlBox={x:b.plotX-e,y:b.plotY-e,width:2*e,height:2*e}):b.shapeArgs=b.plotY=
b.dlBox=void 0}},alignDataLabel:v.column.prototype.alignDataLabel,buildKDTree:e,applyZones:e},{haloPath:function(a){return m.prototype.haloPath.call(this,0===a?0:(this.marker?this.marker.radius||0:0)+a)},ttBelow:!1});b.prototype.beforePadding=function(){var a=this,c=this.len,d=this.chart,b=0,e=c,h=this.isXAxis,m=h?"xData":"yData",t=this.min,v={},x=Math.min(d.plotWidth,d.plotHeight),u=Number.MAX_VALUE,y=-Number.MAX_VALUE,E=this.max-t,D=c/E,F=[];this.series.forEach(function(c){var b=c.options;!c.bubblePadding||
!c.visible&&d.options.chart.ignoreHiddenSeries||(a.allowZoomOutside=!0,F.push(c),h&&(["minSize","maxSize"].forEach(function(a){var c=b[a],d=/%$/.test(c);c=l(c);v[a]=d?x*c/100:c}),c.minPxSize=v.minSize,c.maxPxSize=Math.max(v.maxSize,v.minSize),c=c.zData.filter(r),c.length&&(u=w(b.zMin,k(p(c),!1===b.displayNegative?b.zThreshold:-Number.MAX_VALUE,u)),y=w(b.zMax,Math.max(y,g(c))))))});F.forEach(function(c){var d=c[m],f=d.length;h&&c.getRadii(u,y,c);if(0<E)for(;f--;)if(r(d[f])&&a.dataMin<=d[f]&&d[f]<=
a.max){var g=c.radii?c.radii[f]:0;b=Math.min((d[f]-t)*D-g,b);e=Math.max((d[f]-t)*D+g,e)}});F.length&&0<E&&!this.isLog&&(e-=c,D*=(c+Math.max(0,b)-Math.min(e,c))/c,[["min","userMin",b],["max","userMax",e]].forEach(function(c){"undefined"===typeof w(a.options[c[0]],a[c[1]])&&(a[c[0]]+=c[2]/D)}))};""});y(g,"parts-map/MapBubbleSeries.js",[g["parts/Globals.js"]],function(a){var b=a.merge,g=a.Point,p=a.seriesType,k=a.seriesTypes;k.bubble&&p("mapbubble","bubble",{animationLimit:500,tooltip:{pointFormat:"{point.name}: {point.z}"}},
{xyFromShape:!0,type:"mapbubble",pointArrayMap:["z"],getMapData:k.map.prototype.getMapData,getBox:k.map.prototype.getBox,setData:k.map.prototype.setData,setOptions:k.map.prototype.setOptions},{applyOptions:function(a,p){return a&&"undefined"!==typeof a.lat&&"undefined"!==typeof a.lon?g.prototype.applyOptions.call(this,b(a,this.series.chart.fromLatLonToPoint(a)),p):k.map.prototype.pointClass.prototype.applyOptions.call(this,a,p)},isValid:function(){return"number"===typeof this.z},ttBelow:!1});""});
y(g,"parts-map/HeatmapSeries.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(a,b){var g=b.clamp,p=b.extend,k=b.pick;b=a.colorMapPointMixin;var u=a.merge,r=a.noop,w=a.fireEvent,l=a.Series,h=a.seriesType,e=a.seriesTypes;h("heatmap","scatter",{animation:!1,borderWidth:0,nullColor:"#f7f7f7",dataLabels:{formatter:function(){return this.point.value},inside:!0,verticalAlign:"middle",crop:!1,overflow:!1,padding:0},marker:null,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},
states:{hover:{halo:!1,brightness:.2}}},u(a.colorMapSeriesMixin,{pointArrayMap:["y","value"],hasPointSpecificOptions:!0,getExtremesFromAll:!0,directTouch:!0,init:function(){e.scatter.prototype.init.apply(this,arguments);var a=this.options;a.pointRange=k(a.pointRange,a.colsize||1);this.yAxis.axisPointRange=a.rowsize||1},translate:function(){var a=this.options,b=this.xAxis,e=this.yAxis,h=a.pointPadding||0,f=this.pointPlacementToXValue();this.generatePoints();this.points.forEach(function(c){var d=(a.colsize||
1)/2,m=(a.rowsize||1)/2,l=g(Math.round(b.len-b.translate(c.x-d,0,1,0,1,-f)),-b.len,2*b.len);d=g(Math.round(b.len-b.translate(c.x+d,0,1,0,1,-f)),-b.len,2*b.len);var t=g(Math.round(e.translate(c.y-m,0,1,0,1)),-e.len,2*e.len);m=g(Math.round(e.translate(c.y+m,0,1,0,1)),-e.len,2*e.len);var v=k(c.pointPadding,h);c.plotX=c.clientX=(l+d)/2;c.plotY=(t+m)/2;c.shapeType="rect";c.shapeArgs={x:Math.min(l,d)+v,y:Math.min(t,m)+v,width:Math.max(Math.abs(d-l)-2*v,0),height:Math.max(Math.abs(m-t)-2*v,0)}});w(this,
"afterTranslate")},drawPoints:function(){var a=this.chart.styledMode?"css":"animate";e.column.prototype.drawPoints.call(this);this.points.forEach(function(b){b.graphic[a](this.colorAttribs(b))},this)},hasData:function(){return!!this.processedXData.length},getValidPoints:function(a,b){return l.prototype.getValidPoints.call(this,a,b,!0)},animate:r,getBox:r,drawLegendSymbol:a.LegendSymbolMixin.drawRectangle,alignDataLabel:e.column.prototype.alignDataLabel,getExtremes:function(){l.prototype.getExtremes.call(this,
this.valueData);this.valueMin=this.dataMin;this.valueMax=this.dataMax;l.prototype.getExtremes.call(this)}}),p({haloPath:function(a){if(!a)return[];var b=this.shapeArgs;return["M",b.x-a,b.y-a,"L",b.x-a,b.y+b.height+a,b.x+b.width+a,b.y+b.height+a,b.x+b.width+a,b.y-a,"Z"]}},b));""});y(g,"parts-map/GeoJSON.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(a,b){function g(a,b){var e,h=!1,g=a.x,l=a.y;a=0;for(e=b.length-1;a<b.length;e=a++){var k=b[a][1]>l;var f=b[e][1]>l;k!==f&&g<(b[e][0]-b[a][0])*
(l-b[a][1])/(b[e][1]-b[a][1])+b[a][0]&&(h=!h)}return h}var p=b.extend;b=b.wrap;var k=a.Chart,u=a.format,r=a.merge,w=a.win;k.prototype.transformFromLatLon=function(b,h){if("undefined"===typeof w.proj4)return a.error(21,!1,this),{x:0,y:null};b=w.proj4(h.crs,[b.lon,b.lat]);var e=h.cosAngle||h.rotation&&Math.cos(h.rotation),g=h.sinAngle||h.rotation&&Math.sin(h.rotation);b=h.rotation?[b[0]*e+b[1]*g,-b[0]*g+b[1]*e]:b;return{x:((b[0]-(h.xoffset||0))*(h.scale||1)+(h.xpan||0))*(h.jsonres||1)+(h.jsonmarginX||
0),y:(((h.yoffset||0)-b[1])*(h.scale||1)+(h.ypan||0))*(h.jsonres||1)-(h.jsonmarginY||0)}};k.prototype.transformToLatLon=function(b,h){if("undefined"===typeof w.proj4)a.error(21,!1,this);else{b={x:((b.x-(h.jsonmarginX||0))/(h.jsonres||1)-(h.xpan||0))/(h.scale||1)+(h.xoffset||0),y:((-b.y-(h.jsonmarginY||0))/(h.jsonres||1)+(h.ypan||0))/(h.scale||1)+(h.yoffset||0)};var e=h.cosAngle||h.rotation&&Math.cos(h.rotation),g=h.sinAngle||h.rotation&&Math.sin(h.rotation);h=w.proj4(h.crs,"WGS84",h.rotation?{x:b.x*
e+b.y*-g,y:b.x*g+b.y*e}:b);return{lat:h.y,lon:h.x}}};k.prototype.fromPointToLatLon=function(b){var h=this.mapTransforms,e;if(h){for(e in h)if(Object.hasOwnProperty.call(h,e)&&h[e].hitZone&&g({x:b.x,y:-b.y},h[e].hitZone.coordinates[0]))return this.transformToLatLon(b,h[e]);return this.transformToLatLon(b,h["default"])}a.error(22,!1,this)};k.prototype.fromLatLonToPoint=function(b){var h=this.mapTransforms,e;if(!h)return a.error(22,!1,this),{x:0,y:null};for(e in h)if(Object.hasOwnProperty.call(h,e)&&
h[e].hitZone){var k=this.transformFromLatLon(b,h[e]);if(g({x:k.x,y:-k.y},h[e].hitZone.coordinates[0]))return k}return this.transformFromLatLon(b,h["default"])};a.geojson=function(a,b,e){var h=[],g=[],k=function(a){var b,c=a.length;g.push("M");for(b=0;b<c;b++)1===b&&g.push("L"),g.push(a[b][0],-a[b][1])};b=b||"map";a.features.forEach(function(a){var e=a.geometry,c=e.type;e=e.coordinates;a=a.properties;var d;g=[];"map"===b||"mapbubble"===b?("Polygon"===c?(e.forEach(k),g.push("Z")):"MultiPolygon"===c&&
(e.forEach(function(a){a.forEach(k)}),g.push("Z")),g.length&&(d={path:g})):"mapline"===b?("LineString"===c?k(e):"MultiLineString"===c&&e.forEach(k),g.length&&(d={path:g})):"mappoint"===b&&"Point"===c&&(d={x:e[0],y:-e[1]});d&&h.push(p(d,{name:a.name||a.NAME,properties:a}))});e&&a.copyrightShort&&(e.chart.mapCredits=u(e.chart.options.credits.mapText,{geojson:a}),e.chart.mapCreditsFull=u(e.chart.options.credits.mapTextFull,{geojson:a}));return h};b(k.prototype,"addCredits",function(a,b){b=r(!0,this.options.credits,
b);this.mapCredits&&(b.href=null);a.call(this,b);this.credits&&this.mapCreditsFull&&this.credits.attr({title:this.mapCreditsFull})})});y(g,"parts-map/Map.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(a,b){function g(a,b,g,h,k,f,c,d){return["M",a+k,b,"L",a+g-f,b,"C",a+g-f/2,b,a+g,b+f/2,a+g,b+f,"L",a+g,b+h-c,"C",a+g,b+h-c/2,a+g-c/2,b+h,a+g-c,b+h,"L",a+d,b+h,"C",a+d/2,b+h,a,b+h-d/2,a,b+h-d,"L",a,b+k,"C",a,b+k/2,a+k/2,b,a+k,b,"Z"]}var p=b.extend,k=b.pick,u=a.Chart;b=a.defaultOptions;var r=
a.merge,w=a.Renderer,l=a.SVGRenderer,h=a.VMLRenderer;p(b.lang,{zoomIn:"Zoom in",zoomOut:"Zoom out"});b.mapNavigation={buttonOptions:{alignTo:"plotBox",align:"left",verticalAlign:"top",x:0,width:18,height:18,padding:5,style:{fontSize:"15px",fontWeight:"bold"},theme:{"stroke-width":1,"text-align":"center"}},buttons:{zoomIn:{onclick:function(){this.mapZoom(.5)},text:"+",y:0},zoomOut:{onclick:function(){this.mapZoom(2)},text:"-",y:28}},mouseWheelSensitivity:1.1};a.splitPath=function(a){var b;a=a.replace(/([A-Za-z])/g,
" $1 ");a=a.replace(/^\s*/,"").replace(/\s*$/,"");a=a.split(/[ ,]+/);for(b=0;b<a.length;b++)/[a-zA-Z]/.test(a[b])||(a[b]=parseFloat(a[b]));return a};a.maps={};l.prototype.symbols.topbutton=function(a,b,h,k,l){return g(a-1,b-1,h,k,l.r,l.r,0,0)};l.prototype.symbols.bottombutton=function(a,b,h,k,l){return g(a-1,b-1,h,k,0,0,l.r,l.r)};w===h&&["topbutton","bottombutton"].forEach(function(a){h.prototype.symbols[a]=l.prototype.symbols[a]});a.Map=a.mapChart=function(b,g,h){var e="string"===typeof b||b.nodeName,
l=arguments[e?1:0],f=l,c={endOnTick:!1,visible:!1,minPadding:0,maxPadding:0,startOnTick:!1},d=a.getOptions().credits;var m=l.series;l.series=null;l=r({chart:{panning:"xy",type:"map"},credits:{mapText:k(d.mapText,' \u00a9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>'),mapTextFull:k(d.mapTextFull,"{geojson.copyright}")},tooltip:{followTouchMove:!1},xAxis:c,yAxis:r(c,{reversed:!0})},l,{chart:{inverted:!1,alignTicks:!1}});l.series=f.series=m;return e?new u(b,l,h):new u(l,g)}});y(g,"masters/modules/map.src.js",
[],function(){})});
//# sourceMappingURL=map.js.map