/*
 Highstock JS v8.0.0 (2019-12-10)

 All technical indicators for Highstock

 (c) 2010-2019 Pawel Fus

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/indicators/indicators-all",["highcharts","highcharts/modules/stock"],function(u){a(u);a.Highcharts=u;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function u(h,k,a,l){h.hasOwnProperty(k)||(h[k]=l.apply(null,a))}a=a?a._modules:{};u(a,"mixins/indicator-required.js",[a["parts/Globals.js"]],function(h){var k=h.error;return{isParentLoaded:function(h,
l,e,d,c){if(h)return d?d(h):!0;k(c||this.generateMessage(e,l));return!1},generateMessage:function(h,l){return'Error: "'+h+'" indicator type requires "'+l+'" indicator loaded before. Please read docs: https://api.highcharts.com/highstock/plotOptions.'+h}}});u(a,"indicators/indicators.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"],a["mixins/indicator-required.js"]],function(h,k,a){var l=k.extend,e=k.isArray,d=k.pick,c=k.splat,b=h.error,f=h.Series,r=h.addEvent;k=h.seriesType;var q=h.seriesTypes,
x=h.seriesTypes.ohlc.prototype,n=a.generateMessage;r(h.Series,"init",function(b){b=b.options;b.useOhlcData&&"highcharts-navigator-series"!==b.id&&l(this,{pointValKey:x.pointValKey,keys:x.keys,pointArrayMap:x.pointArrayMap,toYData:x.toYData})});r(f,"afterSetOptions",function(b){b=b.options;var c=b.dataGrouping;c&&b.useOhlcData&&"highcharts-navigator-series"!==b.id&&(c.approximation="ohlc")});k("sma","line",{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,compareToMain:!1,params:{index:0,period:14}},
{processData:function(){var b=this.options.compareToMain,c=this.linkedParent;f.prototype.processData.apply(this,arguments);c&&c.compareValue&&b&&(this.compareValue=c.compareValue)},bindTo:{series:!0,eventName:"updatedData"},hasDerivedData:!0,useCommonDataGrouping:!0,nameComponents:["period"],nameSuffixes:[],calculateOn:"init",requiredIndicators:[],requireIndicators:function(){var b={allLoaded:!0};this.requiredIndicators.forEach(function(c){q[c]?q[c].prototype.requireIndicators():(b.allLoaded=!1,b.needed=
c)});return b},init:function(d,e){function m(){var b=g.points||[],d=(g.xData||[]).length,f=g.getValues(g.linkedParent,g.options.params)||{values:[],xData:[],yData:[]},m=[],e=!0;if(d&&!g.hasGroupedData&&g.visible&&g.points)if(g.cropped){if(g.xAxis){var r=g.xAxis.min;var q=g.xAxis.max}d=g.cropData(f.xData,f.yData,r,q);for(r=0;r<d.xData.length;r++)m.push([d.xData[r]].concat(c(d.yData[r])));d=f.xData.indexOf(g.xData[0]);r=f.xData.indexOf(g.xData[g.xData.length-1]);-1===d&&r===f.xData.length-2&&m[0][0]===
b[0].x&&m.shift();g.updateData(m)}else f.xData.length!==d-1&&f.xData.length!==d+1&&(e=!1,g.updateData(f.values));e&&(g.xData=f.xData,g.yData=f.yData,g.options.data=f.values);!1===g.bindTo.series&&(delete g.processedXData,g.isDirty=!0,g.redraw());g.isDirtyData=!1}var g=this,q=g.requireIndicators();if(!q.allLoaded)return b(n(g.type,q.needed));f.prototype.init.call(g,d,e);d.linkSeries();g.dataEventsToUnbind=[];if(!g.linkedParent)return b("Series "+g.options.linkedTo+" not found! Check `linkedTo`.",!1,
d);g.dataEventsToUnbind.push(r(g.bindTo.series?g.linkedParent:g.linkedParent.xAxis,g.bindTo.eventName,m));if("init"===g.calculateOn)m();else var t=r(g.chart,g.calculateOn,function(){m();t()});return g},getName:function(){var b=this.name,c=[];b||((this.nameComponents||[]).forEach(function(b,f){c.push(this.options.params[b]+d(this.nameSuffixes[f],""))},this),b=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+c.join(", ")+")":""));return b},getValues:function(b,c){var d=c.period,f=
b.xData;b=b.yData;var g=b.length,r=0,q=0,n=[],l=[],t=[],x=-1;if(!(f.length<d)){for(e(b[0])&&(x=c.index?c.index:0);r<d-1;)q+=0>x?b[r]:b[r][x],r++;for(c=r;c<g;c++){q+=0>x?b[c]:b[c][x];var h=[f[c],q/d];n.push(h);l.push(h[0]);t.push(h[1]);q-=0>x?b[c-r]:b[c-r][x]}return{values:n,xData:l,yData:t}}},destroy:function(){this.dataEventsToUnbind.forEach(function(b){b()});f.prototype.destroy.apply(this,arguments)}});""});u(a,"indicators/accumulation-distribution.src.js",[a["parts/Globals.js"]],function(h){var k=
h.seriesType;k("ad","sma",{params:{volumeSeriesID:"volume"}},{nameComponents:!1,nameBase:"Accumulation/Distribution",getValues:function(k,l){var e=l.period,d=k.xData,c=k.yData,b=l.volumeSeriesID,f=k.chart.get(b);l=f&&f.yData;var r=c?c.length:0,q=[],x=[],n=[];if(!(d.length<=e&&r&&4!==c[0].length)){if(f){for(;e<r;e++){k=q.length;b=c[e][1];f=c[e][2];var g=c[e][3],t=l[e];b=[d[e],g===b&&g===f||b===f?0:(2*g-f-b)/(b-f)*t];0<k&&(b[1]+=q[k-1][1]);q.push(b);x.push(b[0]);n.push(b[1])}return{values:q,xData:x,
yData:n}}h.error("Series "+b+" not found! Check `volumeSeriesID`.",!0,k.chart)}}});""});u(a,"indicators/ao.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(h,k){var a=k.correctFloat,l=k.isArray;h.seriesType("ao","sma",{greaterBarColor:"#06B535",lowerBarColor:"#F21313",threshold:0,groupPadding:.2,pointPadding:.2,states:{hover:{halo:{size:0}}}},{nameBase:"AO",nameComponents:!1,markerAttribs:h.noop,getColumnMetrics:h.seriesTypes.column.prototype.getColumnMetrics,crispCol:h.seriesTypes.column.prototype.crispCol,
translate:h.seriesTypes.column.prototype.translate,drawPoints:h.seriesTypes.column.prototype.drawPoints,drawGraph:function(){var e=this.options,d=this.points,c=e.greaterBarColor;e=e.lowerBarColor;var b=d[0];if(!this.userOptions.color&&b)for(b.color=c,b=1;b<d.length;b++)d[b].color=d[b].y>d[b-1].y?c:d[b].y<d[b-1].y?e:d[b-1].color},getValues:function(e){var d=e.xData||[];e=e.yData||[];var c=e.length,b=[],f=[],r=[],q=0,x=0,n;if(!(34>=d.length)&&l(e[0])&&4===e[0].length){for(n=0;33>n;n++){var g=(e[n][1]+
e[n][2])/2;29<=n&&(q=a(q+g));x=a(x+g)}for(n=33;n<c;n++){g=(e[n][1]+e[n][2])/2;q=a(q+g);x=a(x+g);g=q/5;var t=x/34;g=a(g-t);b.push([d[n],g]);f.push(d[n]);r.push(g);g=n+1-5;t=n+1-34;q=a(q-(e[g][1]+e[g][2])/2);x=a(x-(e[t][1]+e[t][2])/2)}return{values:b,xData:f,yData:r}}}});""});u(a,"mixins/multipe-lines.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(h,k){var a=k.defined,l=h.each,e=h.merge,d=h.error,c=h.seriesTypes.sma;return{pointArrayMap:["top","bottom"],pointValKey:"top",linesApiNames:["bottomLine"],
getTranslatedLinesNames:function(b){var c=[];l(this.pointArrayMap,function(d){d!==b&&c.push("plot"+d.charAt(0).toUpperCase()+d.slice(1))});return c},toYData:function(b){var c=[];l(this.pointArrayMap,function(d){c.push(b[d])});return c},translate:function(){var b=this,d=b.pointArrayMap,r=[],e;r=b.getTranslatedLinesNames();c.prototype.translate.apply(b,arguments);l(b.points,function(c){l(d,function(d,f){e=c[d];null!==e&&(c[r[f]]=b.yAxis.toPixels(e,!0))})})},drawGraph:function(){var b=this,f=b.linesApiNames,
r=b.points,q=r.length,x=b.options,n=b.graph,g={options:{gapSize:x.gapSize}},t=[],m=b.getTranslatedLinesNames(b.pointValKey),z;l(m,function(b,c){for(t[c]=[];q--;)z=r[q],t[c].push({x:z.x,plotX:z.plotX,plotY:z[b],isNull:!a(z[b])});q=r.length});l(f,function(f,m){t[m]?(b.points=t[m],x[f]?b.options=e(x[f].styles,g):d('Error: "There is no '+f+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names." at mixin/multiple-line.js:34'),b.graph=b["graph"+f],c.prototype.drawGraph.call(b),
b["graph"+f]=b.graph):d('Error: "'+f+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});b.points=r;b.options=x;b.graph=n;c.prototype.drawGraph.call(b)}}});u(a,"indicators/aroon.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"],a["mixins/multipe-lines.js"]],function(h,k,a){function l(d,c){var b=d[0],f=0,r;for(r=1;r<d.length;r++)if("max"===c&&d[r]>=b||"min"===c&&d[r]<=b)b=d[r],f=r;return f}var e=k.pick;h.seriesType("aroon","sma",{params:{period:25},
marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Aroon Up: {point.y}<br/>Aroon Down: {point.aroonDown}<br/>'},aroonDown:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}},h.merge(a,{nameBase:"Aroon",pointArrayMap:["y","aroonDown"],pointValKey:"y",linesApiNames:["aroonDown"],getValues:function(d,c){c=c.period;var b=d.xData,f=(d=d.yData)?d.length:0,r=[],q=[],x=[],n;for(n=c-1;n<f;n++){var g=d.slice(n-c+1,
n+2);var t=l(g.map(function(b){return e(b[2],b)}),"min");g=l(g.map(function(b){return e(b[1],b)}),"max");g=g/c*100;t=t/c*100;b[n+1]&&(r.push([b[n+1],g,t]),q.push(b[n+1]),x.push([g,t]))}return{values:r,xData:q,yData:x}}}));""});u(a,"indicators/aroon-oscillator.src.js",[a["parts/Globals.js"],a["mixins/multipe-lines.js"],a["mixins/indicator-required.js"]],function(h,a,p){var l=h.seriesTypes.aroon;h.seriesType("aroonoscillator","aroon",{params:{period:25},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b>: {point.y}'}},
h.merge(a,{nameBase:"Aroon Oscillator",pointArrayMap:["y"],pointValKey:"y",linesApiNames:[],init:function(){var e=arguments,d=this;p.isParentLoaded(l,"aroon",d.type,function(c){c.prototype.init.apply(d,e)})},getValues:function(e,d){var c=[],b=[],f=[];e=l.prototype.getValues.call(this,e,d);for(d=0;d<e.yData.length;d++){var r=e.yData[d][0];var q=e.yData[d][1];r-=q;c.push([e.xData[d],r]);b.push(e.xData[d]);f.push(r)}return{values:c,xData:b,yData:f}}}));""});u(a,"indicators/atr.src.js",[a["parts/Globals.js"],
a["parts/Utilities.js"]],function(h,a){function k(d,c){return Math.max(d[1]-d[2],c===e?0:Math.abs(d[1]-c[3]),c===e?0:Math.abs(d[2]-c[3]))}var l=a.isArray;h=h.seriesType;var e;h("atr","sma",{params:{period:14}},{getValues:function(d,c){c=c.period;var b=d.xData,f=(d=d.yData)?d.length:0,r=1,e=0,x=0,n=[],g=[],t=[],m;var z=[[b[0],d[0]]];if(!(b.length<=c)&&l(d[0])&&4===d[0].length){for(m=1;m<=f;m++)if(z.push([b[m],d[m]]),c<r){var v=c;var h=b[m-1],a=k(d[m-1],d[m-2]);v=[h,(e*(v-1)+a)/v];e=v[1];n.push(v);
g.push(v[0]);t.push(v[1])}else c===r?(e=x/(m-1),n.push([b[m-1],e]),g.push(b[m-1]),t.push(e)):x+=k(d[m-1],d[m-2]),r++;return{values:n,xData:g,yData:t}}}});""});u(a,"indicators/bollinger-bands.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"],a["mixins/multipe-lines.js"]],function(h,a,p){var l=a.isArray,e=h.merge,d=h.seriesTypes.sma;h.seriesType("bb","sma",{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},
tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"}},h.merge(p,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameComponents:["period","standardDeviation"],linesApiNames:["topLine","bottomLine"],init:function(){d.prototype.init.apply(this,arguments);this.options=e({topLine:{styles:{lineColor:this.color}},
bottomLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(c,b){var f=b.period,e=b.standardDeviation,q=c.xData,x=(c=c.yData)?c.length:0,n=[],g=[],t=[],m;if(!(q.length<f)){var z=l(c[0]);for(m=f;m<=x;m++){var v=q.slice(m-f,m);var h=c.slice(m-f,m);var a=d.prototype.getValues.call(this,{xData:v,yData:h},b);v=a.xData[0];a=a.yData[0];for(var k=0,p=h.length,y=0;y<p;y++){var F=(z?h[y][b.index]:h[y])-a;k+=F*F}F=Math.sqrt(k/(p-1));h=a+e*F;F=a-e*F;n.push([v,h,a,F]);g.push(v);t.push([h,a,F])}return{values:n,
xData:g,yData:t}}}}));""});u(a,"indicators/cci.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(h,a){function k(e){return e.reduce(function(d,c){return d+c},0)}var l=a.isArray;h=h.seriesType;h("cci","sma",{params:{period:14}},{getValues:function(e,d){d=d.period;var c=e.xData,b=(e=e.yData)?e.length:0,f=[],r=1,q=[],x=[],n=[];if(!(c.length<=d)&&l(e[0])&&4===e[0].length){for(;r<d;){var g=e[r-1];f.push((g[1]+g[2]+g[3])/3);r++}for(r=d;r<=b;r++){g=e[r-1];g=(g[1]+g[2]+g[3])/3;var t=f.push(g);
var m=f.slice(t-d);t=k(m)/d;var z,h=m.length,a=0;for(z=0;z<h;z++)a+=Math.abs(t-m[z]);m=a/d;g=(g-t)/(.015*m);q.push([c[r-1],g]);x.push(c[r-1]);n.push(g)}return{values:q,xData:x,yData:n}}}});""});u(a,"indicators/cmf.src.js",[a["parts/Globals.js"]],function(h){h.seriesType("cmf","sma",{params:{period:14,volumeSeriesID:"volume"}},{nameBase:"Chaikin Money Flow",isValid:function(){var h=this.chart,a=this.options,l=this.linkedParent;h=this.volumeSeries||(this.volumeSeries=h.get(a.params.volumeSeriesID));
var e=l&&l.yData&&4===l.yData[0].length;return!!(l&&h&&l.xData&&l.xData.length>=a.params.period&&h.xData&&h.xData.length>=a.params.period&&e)},getValues:function(h,a){if(this.isValid())return this.getMoneyFlow(h.xData,h.yData,this.volumeSeries.yData,a.period)},getMoneyFlow:function(h,a,l,e){function d(b,c){var d=b[1],f=b[2];b=b[3];return null!==c&&null!==d&&null!==f&&null!==b&&d!==f?(b-f-(d-b))/(d-f)*c:(t=g,null)}var c=a.length,b=[],f=0,r=0,q=[],x=[],n=[],g,t=-1;if(0<e&&e<=c){for(g=0;g<e;g++)b[g]=
d(a[g],l[g]),f+=l[g],r+=b[g];q.push(h[g-1]);x.push(g-t>=e&&0!==f?r/f:null);for(n.push([q[0],x[0]]);g<c;g++){b[g]=d(a[g],l[g]);f-=l[g-e];f+=l[g];r-=b[g-e];r+=b[g];var m=[h[g],g-t>=e?r/f:null];q.push(m[0]);x.push(m[1]);n.push([m[0],m[1]])}}return{values:n,xData:q,yData:x}}});""});u(a,"indicators/dpo.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(h,a){function k(d,c,b,f,r){c=e(c[b][f],c[b]);return r?l(d-c):l(d+c)}var l=a.correctFloat,e=a.pick;h.seriesType("dpo","sma",{params:{period:21}},
{nameBase:"DPO",getValues:function(d,c){var b=c.period;c=c.index;var f=b+Math.floor(b/2+1),r=d.xData||[];d=d.yData||[];var q=d.length,h=[],n=[],g=[],l=0,m,z;if(!(r.length<=f)){for(m=0;m<b-1;m++)l=k(l,d,m,c);for(z=0;z<=q-f;z++){var a=z+b-1;m=z+f-1;l=k(l,d,a,c);a=e(d[m][c],d[m]);a-=l/b;l=k(l,d,z,c,!0);h.push([r[m],a]);n.push(r[m]);g.push(a)}return{values:h,xData:n,yData:g}}}});""});u(a,"indicators/ema.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(h,a){var k=a.correctFloat,l=a.isArray;
h=h.seriesType;h("ema","sma",{params:{index:3,period:9}},{accumulatePeriodPoints:function(e,d,c){for(var b=0,f=0,r;f<e;)r=0>d?c[f]:c[f][d],b+=r,f++;return b},calculateEma:function(e,d,c,b,f,r,q){e=e[c-1];d=0>r?d[c-1]:d[c-1][r];b="undefined"===typeof f?q:k(d*b+f*(1-b));return[e,b]},getValues:function(e,d){var c=d.period,b=e.xData,f=(e=e.yData)?e.length:0,r=2/(c+1),q=[],h=[],n=[],g=-1;if(!(f<c)){l(e[0])&&(g=d.index?d.index:0);d=this.accumulatePeriodPoints(c,g,e);for(d/=c;c<f+1;c++){var a=this.calculateEma(b,
e,c,r,a,g,d);q.push(a);h.push(a[0]);n.push(a[1]);a=a[1]}return{values:q,xData:h,yData:n}}}});""});u(a,"indicators/chaikin.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"],a["mixins/indicator-required.js"]],function(h,a,p){var l=a.correctFloat,e=h.seriesTypes.ema,d=h.seriesTypes.ad,c=h.error;h.seriesType("chaikin","ema",{params:{volumeSeriesID:"volume",periods:[3,10]}},{nameBase:"Chaikin Osc",nameComponents:["periods"],init:function(){var b=arguments,c=this;p.isParentLoaded(e,"ema",c.type,function(d){d.prototype.init.apply(c,
b)})},getValues:function(b,f){var r=f.periods,q=f.period,h=[],n=[],g=[],a;if(2!==r.length||r[1]<=r[0])c('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."');else if(f=d.prototype.getValues.call(this,b,{volumeSeriesID:f.volumeSeriesID,period:q}))if(b=e.prototype.getValues.call(this,f,{period:r[0]}),f=e.prototype.getValues.call(this,f,{period:r[1]}),b&&f){r=r[1]-r[0];for(a=0;a<f.yData.length;a++)q=l(b.yData[a+r]-f.yData[a]),h.push([f.xData[a],q]),n.push(f.xData[a]),
g.push(q);return{values:h,xData:n,yData:g}}}});""});u(a,"indicators/dema.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"],a["mixins/indicator-required.js"]],function(a,k,p){var l=k.correctFloat,e=k.isArray,d=a.seriesTypes.ema;a.seriesType("dema","ema",{},{init:function(){var c=arguments,b=this;p.isParentLoaded(d,"ema",b.type,function(d){d.prototype.init.apply(b,c)})},getEMA:function(c,b,f,e,q,a){return d.prototype.calculateEma(a||[],c,"undefined"===typeof q?1:q,this.chart.series[0].EMApercent,
b,"undefined"===typeof e?-1:e,f)},getValues:function(c,b){var f=b.period,r=2*f,q=c.xData,a=c.yData,n=a?a.length:0,g=-1,h=[],m=[],z=[],v=0,k=[],A;c.EMApercent=2/(f+1);if(!(n<2*f-1)){e(a[0])&&(g=b.index?b.index:0);c=d.prototype.accumulatePeriodPoints(f,g,a);b=c/f;c=0;for(A=f;A<n+2;A++){A<n+1&&(v=this.getEMA(a,w,b,g,A)[1],k.push(v));var w=v;if(A<r)c+=v;else{A===r&&(b=c/f);v=k[A-f-1];var p=this.getEMA([v],p,b)[1];var y=[q[A-2],l(2*v-p)];h.push(y);m.push(y[0]);z.push(y[1])}}return{values:h,xData:m,yData:z}}}});
""});u(a,"indicators/tema.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"],a["mixins/indicator-required.js"]],function(a,k,p){var l=k.correctFloat,e=k.isArray,d=a.seriesTypes.ema;a.seriesType("tema","ema",{},{init:function(){var c=arguments,b=this;p.isParentLoaded(d,"ema",b.type,function(d){d.prototype.init.apply(b,c)})},getEMA:function(c,b,f,e,q,a){return d.prototype.calculateEma(a||[],c,"undefined"===typeof q?1:q,this.chart.series[0].EMApercent,b,"undefined"===typeof e?-1:e,f)},getTemaPoint:function(c,
b,d,e){return[c[e-3],l(3*d.level1-3*d.level2+d.level3)]},getValues:function(c,b){var f=b.period,r=2*f,q=3*f,a=c.xData,n=c.yData,g=n?n.length:0,l=-1,m=[],h=[],v=[],k=[],A=[],w,p,y={};c.EMApercent=2/(f+1);if(!(g<3*f-2)){e(n[0])&&(l=b.index?b.index:0);c=d.prototype.accumulatePeriodPoints(f,l,n);b=c/f;c=0;for(w=f;w<g+3;w++){w<g+1&&(y.level1=this.getEMA(n,F,b,l,w)[1],k.push(y.level1));var F=y.level1;if(w<r)c+=y.level1;else{w===r&&(b=c/f,c=0);y.level1=k[w-f-1];y.level2=this.getEMA([y.level1],C,b)[1];A.push(y.level2);
var C=y.level2;if(w<q)c+=y.level2;else{w===q&&(b=c/f);w===g+1&&(y.level1=k[w-f-1],y.level2=this.getEMA([y.level1],C,b)[1],A.push(y.level2));y.level1=k[w-f-2];y.level2=A[w-2*f-1];y.level3=this.getEMA([y.level2],y.prevLevel3,b)[1];if(p=this.getTemaPoint(a,q,y,w))m.push(p),h.push(p[0]),v.push(p[1]);y.prevLevel3=y.level3}}}return{values:m,xData:h,yData:v}}}});""});u(a,"indicators/trix.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"],a["mixins/indicator-required.js"]],function(a,k,p){var l=k.correctFloat,
e=a.seriesTypes.tema;a.seriesType("trix","tema",{},{init:function(){var d=arguments,c=this;p.isParentLoaded(e,"tema",c.type,function(b){b.prototype.init.apply(c,d)})},getTemaPoint:function(d,c,b,f){if(f>c)var e=[d[f-3],0!==b.prevLevel3?l(b.level3-b.prevLevel3)/b.prevLevel3*100:null];return e}});""});u(a,"indicators/apo.src.js",[a["parts/Globals.js"],a["mixins/indicator-required.js"]],function(a,k){var h=a.seriesTypes.ema,l=a.error;a.seriesType("apo","ema",{params:{periods:[10,20]}},{nameBase:"APO",
nameComponents:["periods"],init:function(){var e=arguments,d=this;k.isParentLoaded(h,"ema",d.type,function(c){c.prototype.init.apply(d,e)})},getValues:function(e,d){var c=d.periods,b=d.index;d=[];var f=[],r=[],q;if(2!==c.length||c[1]<=c[0])l('Error: "APO requires two periods. Notice, first period should be lower than the second one."');else{var a=h.prototype.getValues.call(this,e,{index:b,period:c[0]});e=h.prototype.getValues.call(this,e,{index:b,period:c[1]});if(a&&e){c=c[1]-c[0];for(q=0;q<e.yData.length;q++)b=
a.yData[q+c]-e.yData[q],d.push([e.xData[q],b]),f.push(e.xData[q]),r.push(b);return{values:d,xData:f,yData:r}}}}});""});u(a,"indicators/ichimoku-kinko-hyo.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,k){function h(b){return b.reduce(function(b,c){return Math.max(b,c[1])},-Infinity)}function l(b){return b.reduce(function(b,c){return Math.min(b,c[2])},Infinity)}function e(b){return{high:h(b),low:l(b)}}function d(b){var c,d,f,e,g;b.series.forEach(function(b){if(b.xData)for(e=b.xData,
g=d=b.xIncrement?1:e.length-1;0<g;g--)if(f=e[g]-e[g-1],c===x||f<c)c=f});return c}function c(b,c,d,f){if(b&&c&&d&&f){var e=c.plotX-b.plotX;c=c.plotY-b.plotY;var g=f.plotX-d.plotX;f=f.plotY-d.plotY;var m=b.plotX-d.plotX,r=b.plotY-d.plotY;d=(-c*m+e*r)/(-g*c+e*f);g=(g*r-f*m)/(-g*c+e*f);if(0<=d&&1>=d&&0<=g&&1>=g)return{plotX:b.plotX+g*e,plotY:b.plotY+g*c}}return!1}function b(b){var c=b.indicator;c.points=b.points;c.nextPoints=b.nextPoints;c.color=b.color;c.options=n(b.options.senkouSpan.styles,b.gap);
c.graph=b.graph;c.fillGraph=!0;t.prototype.drawGraph.call(c)}var f=k.defined,r=k.isArray,q=k.objectEach,x;k=a.seriesType;var n=a.merge,g=a.color,t=a.seriesTypes.sma;a.approximations["ichimoku-averages"]=function(){var b=[],c;[].forEach.call(arguments,function(d,f){b.push(a.approximations.average(d));c=!c&&"undefined"===typeof b[f]});return c?void 0:b};k("ikh","sma",{params:{period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},
tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}},{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB","period",
"periodTenkan"],init:function(){t.prototype.init.apply(this,arguments);this.options=n({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:g(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:g(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:g(this.color).setOpacity(.2).get()}}},this.options)},toYData:function(b){return[b.tenkanSen,b.kijunSen,
b.chikouSpan,b.senkouSpanA,b.senkouSpanB]},translate:function(){var b=this;t.prototype.translate.apply(b);b.points.forEach(function(c){b.pointArrayMap.forEach(function(d){f(c[d])&&(c["plot"+d]=b.yAxis.toPixels(c[d],!0),c.plotY=c["plot"+d],c.tooltipPos=[c.plotX,c["plot"+d]],c.isNull=!1)})})},drawGraph:function(){var d=this,e=d.points,g=e.length,r=d.options,a=d.graph,l=d.color,h={options:{gapSize:r.gapSize}},x=d.pointArrayMap.length,k=[[],[],[],[],[],[]],p={tenkanLine:k[0],kijunLine:k[1],chikouLine:k[2],
senkouSpanA:k[3],senkouSpanB:k[4],senkouSpan:k[5]},u=[],B=d.options.senkouSpan,G=B.color||B.styles.fill,J=B.negativeColor,M=[[],[]],L=[[],[]],O=0,I,P,N;for(d.ikhMap=p;g--;){var D=e[g];for(I=0;I<x;I++)B=d.pointArrayMap[I],f(D[B])&&k[I].push({plotX:D.plotX,plotY:D["plot"+B],isNull:!1});J&&g!==e.length-1&&(B=p.senkouSpanB.length-1,D=c(p.senkouSpanA[B-1],p.senkouSpanA[B],p.senkouSpanB[B-1],p.senkouSpanB[B]),I={plotX:D.plotX,plotY:D.plotY,isNull:!1,intersectPoint:!0},D&&(p.senkouSpanA.splice(B,0,I),p.senkouSpanB.splice(B,
0,I),u.push(B)))}q(p,function(b,c){r[c]&&"senkouSpan"!==c&&(d.points=k[O],d.options=n(r[c].styles,h),d.graph=d["graph"+c],d.fillGraph=!1,d.color=l,t.prototype.drawGraph.call(d),d["graph"+c]=d.graph);O++});d.graphCollection&&d.graphCollection.forEach(function(b){d[b].destroy();delete d[b]});d.graphCollection=[];if(J&&p.senkouSpanA[0]&&p.senkouSpanB[0]){u.unshift(0);u.push(p.senkouSpanA.length-1);for(x=0;x<u.length-1;x++){B=u[x];D=u[x+1];g=p.senkouSpanB.slice(B,D+1);B=p.senkouSpanA.slice(B,D+1);if(1<=
Math.floor(g.length/2))if(D=Math.floor(g.length/2),g[D].plotY===B[D].plotY){for(N=I=D=0;N<g.length;N++)D+=g[N].plotY,I+=B[N].plotY;D=D>I?0:1}else D=g[D].plotY>B[D].plotY?0:1;else D=g[0].plotY>B[0].plotY?0:1;M[D]=M[D].concat(g);L[D]=L[D].concat(B)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(c,f){M[f].length&&L[f].length&&(P=0===f?G:J,b({indicator:d,points:M[f],nextPoints:L[f],color:P,options:r,gap:h,graph:d[c]}),d[c]=d.graph,d.graphCollection.push(c))})}else b({indicator:d,
points:p.senkouSpanB,nextPoints:p.senkouSpanA,color:G,options:r,gap:h,graph:d.graphsenkouSpan}),d.graphsenkouSpan=d.graph;delete d.nextPoints;delete d.fillGraph;d.points=e;d.options=r;d.graph=a},getGraphPath:function(b){var c=[];b=b||this.points;if(this.fillGraph&&this.nextPoints){var d=t.prototype.getGraphPath.call(this,this.nextPoints);d[0]="L";var f=t.prototype.getGraphPath.call(this,b);d=d.slice(0,f.length);for(var e=d.length-1;0<e;e-=3)c.push(d[e-2],d[e-1],d[e]);f=f.concat(c)}else f=t.prototype.getGraphPath.apply(this,
arguments);return f},getValues:function(b,c){var f=c.period,g=c.periodTenkan;c=c.periodSenkouSpanB;var a=b.xData,q=b.yData,n=q&&q.length||0;b=d(b.xAxis);var l=[],h=[],m;if(!(a.length<=f)&&r(q[0])&&4===q[0].length){var t=a[0]-f*b;for(m=0;m<f;m++)h.push(t+m*b);for(m=0;m<n;m++){if(m>=g){var k=q.slice(m-g,m);k=e(k);k=(k.high+k.low)/2}if(m>=f){var z=q.slice(m-f,m);z=e(z);z=(z.high+z.low)/2;var p=(k+z)/2}if(m>=c){var u=q.slice(m-c,m);u=e(u);u=(u.high+u.low)/2}t=q[m][3];var L=a[m];l[m]===x&&(l[m]=[]);l[m+
f]===x&&(l[m+f]=[]);l[m+f][0]=k;l[m+f][1]=z;l[m+f][2]=x;l[m][2]=t;m<=f&&(l[m+f][3]=x,l[m+f][4]=x);l[m+2*f]===x&&(l[m+2*f]=[]);l[m+2*f][3]=p;l[m+2*f][4]=u;h.push(L)}for(m=1;m<=f;m++)h.push(L+m*b);return{values:l,xData:h,yData:l}}}});""});u(a,"indicators/keltner-channels.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"],a["mixins/multipe-lines.js"]],function(a,k,p){var l=k.correctFloat,e=a.seriesTypes.sma,d=a.seriesTypes.ema,c=a.seriesTypes.atr,b=a.merge;a.seriesType("keltnerchannels","sma",{params:{period:20,
periodATR:10,multiplierATR:2},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Upper Channel: {point.top}<br/>EMA({series.options.params.period}): {point.middle}<br/>Lower Channel: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"},lineWidth:1},b(p,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Keltner Channels",
nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine","bottomLine"],requiredIndicators:["ema","atr"],init:function(){e.prototype.init.apply(this,arguments);this.options=b({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(b,e){var f=e.period,r=e.periodATR,a=e.multiplierATR,g=b.yData;g=g?g.length:0;var h=[];e=d.prototype.getValues(b,{period:f,index:e.index});var m=c.prototype.getValues(b,{period:r}),k=[],v=
[],p;if(!(g<f)){for(p=f;p<=g;p++){var A=e.values[p-f];var w=m.values[p-r];var E=A[0];b=l(A[1]+a*w[1]);w=l(A[1]-a*w[1]);A=A[1];h.push([E,b,A,w]);k.push(E);v.push([b,A,w])}return{values:h,xData:k,yData:v}}}}));""});u(a,"indicators/macd.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,k){var h=k.correctFloat,l=k.defined;k=a.seriesType;var e=a.merge,d=a.seriesTypes.sma,c=a.seriesTypes.ema;k("macd","sma",{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},signalLine:{zones:[],
styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},dataGrouping:{approximation:"averages"},minPointLength:0},{nameComponents:["longPeriod","shortPeriod","signalPeriod"],requiredIndicators:["ema"],pointArrayMap:["y",
"signal","MACD"],parallelArrays:["x","y","signal","MACD"],pointValKey:"y",markerAttribs:a.noop,getColumnMetrics:a.seriesTypes.column.prototype.getColumnMetrics,crispCol:a.seriesTypes.column.prototype.crispCol,init:function(){d.prototype.init.apply(this,arguments);this.options&&(this.options=e({signalLine:{styles:{lineColor:this.color}},macdLine:{styles:{color:this.color}}},this.options),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),
startIndex:this.macdZones.zones.length},this.resetZones=!0)},toYData:function(b){return[b.y,b.signal,b.MACD]},translate:function(){var b=this,c=["plotSignal","plotMACD"];a.seriesTypes.column.prototype.translate.apply(b);b.points.forEach(function(d){[d.signal,d.MACD].forEach(function(f,e){null!==f&&(d[c[e]]=b.yAxis.toPixels(f,!0))})})},destroy:function(){this.graph=null;this.graphmacd=this.graphmacd&&this.graphmacd.destroy();this.graphsignal=this.graphsignal&&this.graphsignal.destroy();d.prototype.destroy.apply(this,
arguments)},drawPoints:a.seriesTypes.column.prototype.drawPoints,drawGraph:function(){for(var b=this,c=b.points,a=c.length,q=b.options,h=b.zones,n={options:{gapSize:q.gapSize}},g=[[],[]],t;a--;)t=c[a],l(t.plotMACD)&&g[0].push({plotX:t.plotX,plotY:t.plotMACD,isNull:!l(t.plotMACD)}),l(t.plotSignal)&&g[1].push({plotX:t.plotX,plotY:t.plotSignal,isNull:!l(t.plotMACD)});["macd","signal"].forEach(function(c,f){b.points=g[f];b.options=e(q[c+"Line"].styles,n);b.graph=b["graph"+c];b.currentLineZone=c+"Zones";
b.zones=b[b.currentLineZone].zones;d.prototype.drawGraph.call(b);b["graph"+c]=b.graph});b.points=c;b.options=q;b.zones=h;b.currentLineZone=null},getZonesGraphs:function(b){var c=d.prototype.getZonesGraphs.call(this,b),e=c;this.currentLineZone&&(e=c.splice(this[this.currentLineZone].startIndex+1),e.length?e.splice(0,0,b[0]):e=[b[0]]);return e},applyZones:function(){var b=this.zones;this.zones=this.signalZones.zones;d.prototype.applyZones.call(this);this.graphmacd&&this.options.macdLine.zones.length&&
this.graphmacd.hide();this.zones=b},getValues:function(b,d){var f=0,e=[],a=[],n=[];if(!(b.xData.length<d.longPeriod+d.signalPeriod)){var g=c.prototype.getValues(b,{period:d.shortPeriod});var t=c.prototype.getValues(b,{period:d.longPeriod});g=g.values;t=t.values;for(b=1;b<=g.length;b++)l(t[b-1])&&l(t[b-1][1])&&l(g[b+d.shortPeriod+1])&&l(g[b+d.shortPeriod+1][0])&&e.push([g[b+d.shortPeriod+1][0],0,null,g[b+d.shortPeriod+1][1]-t[b-1][1]]);for(b=0;b<e.length;b++)a.push(e[b][0]),n.push([0,null,e[b][3]]);
d=c.prototype.getValues({xData:a,yData:n},{period:d.signalPeriod,index:2});d=d.values;for(b=0;b<e.length;b++)e[b][0]>=d[0][0]&&(e[b][2]=d[f][1],n[b]=[0,d[f][1],e[b][3]],null===e[b][3]?(e[b][1]=0,n[b][0]=0):(e[b][1]=h(e[b][3]-d[f][1]),n[b][0]=h(e[b][3]-d[f][1])),f++);return{values:e,xData:a,yData:n}}}});""});u(a,"indicators/mfi.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,k){function h(d){return d.reduce(function(c,b){return c+b})}function l(d){return(d[1]+d[2]+d[3])/3}var e=
k.isArray;a.seriesType("mfi","sma",{params:{period:14,volumeSeriesID:"volume",decimals:4}},{nameBase:"Money Flow Index",getValues:function(d,c){var b=c.period,f=d.xData,r=d.yData,q=r?r.length:0,x=c.decimals,n=1,g=d.chart.get(c.volumeSeriesID),t=g&&g.yData,m=[],k=[],v=[],p=[],A=[];if(!g)a.error("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,d.chart);else if(!(f.length<=b)&&e(r[0])&&4===r[0].length&&t){for(d=l(r[n]);n<b+1;)c=d,d=l(r[n]),c=d>=c,g=d*t[n],p.push(c?g:0),A.push(c?0:
g),n++;for(b=n-1;b<q;b++)b>n-1&&(p.shift(),A.shift(),c=d,d=l(r[b]),c=d>c,g=d*t[b],p.push(c?g:0),A.push(c?0:g)),c=h(A),g=h(p),c=g/c,c=parseFloat((100-100/(1+c)).toFixed(x)),m.push([f[b],c]),k.push(f[b]),v.push(c);return{values:m,xData:k,yData:v}}}});""});u(a,"indicators/momentum.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,k){function h(e,d,c,b,f){c=c[b-1][3]-c[b-f-1][3];d=d[b-1];e.shift();return[d,c]}var l=k.isArray;a=a.seriesType;a("momentum","sma",{params:{period:14}},{nameBase:"Momentum",
getValues:function(e,d){d=d.period;var c=e.xData,b=(e=e.yData)?e.length:0,f=c[0],a=[],q=[],x=[];if(!(c.length<=d)&&l(e[0])){var n=e[0][3];n=[[f,n]];for(f=d+1;f<b;f++){var g=h(n,c,e,f,d,void 0);a.push(g);q.push(g[0]);x.push(g[1])}g=h(n,c,e,f,d,void 0);a.push(g);q.push(g[0]);x.push(g[1]);return{values:a,xData:q,yData:x}}}});""});u(a,"indicators/natr.src.js",[a["parts/Globals.js"]],function(a){var h=a.seriesTypes.atr;a.seriesType("natr","sma",{tooltip:{valueSuffix:"%"}},{requiredIndicators:["atr"],getValues:function(a,
l){var e=h.prototype.getValues.apply(this,arguments),d=e.values.length,c=l.period-1,b=a.yData,f=0;if(e){for(;f<d;f++)e.yData[f]=e.values[f][1]/b[c][3]*100,e.values[f][1]=e.yData[f],c++;return e}}});""});u(a,"indicators/pivot-points.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,k){function h(c,b){var f=c.series.pointArrayMap,e=f.length;for(d.prototype.pointClass.prototype[b].call(c);e--;)b="dataLabel"+f[e],c[b]&&c[b].element&&c[b].destroy(),c[b]=null}var l=k.defined,e=k.isArray,
d=a.seriesTypes.sma;a.seriesType("pivotpoints","sma",{params:{period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}},{nameBase:"Pivot Points",pointArrayMap:"R4 R3 R2 R1 P S1 S2 S3 S4".split(" "),pointValKey:"P",toYData:function(c){return[c.P]},translate:function(){var c=this;d.prototype.translate.apply(c);c.points.forEach(function(b){c.pointArrayMap.forEach(function(d){l(b[d])&&(b["plot"+
d]=c.yAxis.toPixels(b[d],!0))})});c.plotEndPoint=c.xAxis.toPixels(c.endPoint,!0)},getGraphPath:function(c){for(var b=this,f=c.length,e=[[],[],[],[],[],[],[],[],[]],a=[],h=b.plotEndPoint,n=b.pointArrayMap.length,g,t,m;f--;){t=c[f];for(m=0;m<n;m++)g=b.pointArrayMap[m],l(t[g])&&e[m].push({plotX:t.plotX,plotY:t["plot"+g],isNull:!1},{plotX:h,plotY:t["plot"+g],isNull:!1},{plotX:h,plotY:null,isNull:!0});h=t.plotX}e.forEach(function(c){a=a.concat(d.prototype.getGraphPath.call(b,c))});return a},drawDataLabels:function(){var c=
this,b=c.pointArrayMap,e,a,l;if(c.options.dataLabels.enabled){var h=c.points.length;b.concat([!1]).forEach(function(f,g){for(l=h;l--;)a=c.points[l],f?(a.y=a[f],a.pivotLine=f,a.plotY=a["plot"+f],e=a["dataLabel"+f],g&&(a["dataLabel"+b[g-1]]=a.dataLabel),a.dataLabels||(a.dataLabels=[]),a.dataLabels[0]=a.dataLabel=e=e&&e.element?e:null):a["dataLabel"+b[g-1]]=a.dataLabel;d.prototype.drawDataLabels.apply(c,arguments)})}},getValues:function(c,b){var d=b.period,a=c.xData,l=(c=c.yData)?c.length:0;b=this[b.algorithm+
"Placement"];var h=[],n=[],g=[],t;if(!(a.length<d)&&e(c[0])&&4===c[0].length){for(t=d+1;t<=l+d;t+=d){var m=a.slice(t-d-1,t);var k=c.slice(t-d-1,t);var v=m.length;var p=m[v-1];k=this.getPivotAndHLC(k);k=b(k);k=h.push([p].concat(k));n.push(p);g.push(h[k-1].slice(1))}this.endPoint=m[0]+(p-m[0])/v*d;return{values:h,xData:n,yData:g}}},getPivotAndHLC:function(c){var b=-Infinity,d=Infinity,e=c[c.length-1][3];c.forEach(function(c){b=Math.max(b,c[1]);d=Math.min(d,c[2])});return[(b+d+e)/3,b,d,e]},standardPlacement:function(c){var b=
c[1]-c[2];return[null,null,c[0]+b,2*c[0]-c[2],c[0],2*c[0]-c[1],c[0]-b,null,null]},camarillaPlacement:function(c){var b=c[1]-c[2];return[c[3]+1.5*b,c[3]+1.25*b,c[3]+1.1666*b,c[3]+1.0833*b,c[0],c[3]-1.0833*b,c[3]-1.1666*b,c[3]-1.25*b,c[3]-1.5*b]},fibonacciPlacement:function(c){var b=c[1]-c[2];return[null,c[0]+b,c[0]+.618*b,c[0]+.382*b,c[0],c[0]-.382*b,c[0]-.618*b,c[0]-b,null]}},{destroyElements:function(){h(this,"destroyElements")},destroy:function(){h(this,"destroyElements")}});""});u(a,"indicators/ppo.src.js",
[a["parts/Globals.js"],a["parts/Utilities.js"],a["mixins/indicator-required.js"]],function(a,k,p){var l=k.correctFloat,e=a.seriesTypes.ema,d=a.error;a.seriesType("ppo","ema",{params:{periods:[12,26]}},{nameBase:"PPO",nameComponents:["periods"],init:function(){var c=arguments,b=this;p.isParentLoaded(e,"ema",b.type,function(d){d.prototype.init.apply(b,c)})},getValues:function(c,b){var f=b.periods,a=b.index;b=[];var q=[],h=[],n;if(2!==f.length||f[1]<=f[0])d('Error: "PPO requires two periods. Notice, first period should be lower than the second one."');
else{var g=e.prototype.getValues.call(this,c,{index:a,period:f[0]});c=e.prototype.getValues.call(this,c,{index:a,period:f[1]});if(g&&c){f=f[1]-f[0];for(n=0;n<c.yData.length;n++)a=l((g.yData[n+f]-c.yData[n])/c.yData[n]*100),b.push([c.xData[n],a]),q.push(c.xData[n]),h.push(a);return{values:b,xData:q,yData:h}}}}});""});u(a,"mixins/reduce-array.js",[a["parts/Globals.js"]],function(a){var h=a.reduce;return{minInArray:function(a,l){return h(a,function(e,d){return Math.min(e,d[l])},Number.MAX_VALUE)},maxInArray:function(a,
l){return h(a,function(e,d){return Math.max(e,d[l])},-Number.MAX_VALUE)},getArrayExtremes:function(a,l,e){return h(a,function(d,c){return[Math.min(d[0],c[l]),Math.max(d[1],c[e])]},[Number.MAX_VALUE,-Number.MAX_VALUE])}}});u(a,"indicators/price-channel.src.js",[a["parts/Globals.js"],a["mixins/reduce-array.js"],a["mixins/multipe-lines.js"]],function(a,k,p){var l=k.getArrayExtremes;k=a.merge;a.seriesType("pc","sma",{params:{period:20},lineWidth:1,topLine:{styles:{lineColor:"#90ed7d",lineWidth:1}},bottomLine:{styles:{lineColor:"#f45b5b",
lineWidth:1}},dataGrouping:{approximation:"averages"}},k(p,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Price Channel",nameComponents:["period"],linesApiNames:["topLine","bottomLine"],getValues:function(e,d){d=d.period;var c=e.xData,b=(e=e.yData)?e.length:0,a=[],r=[],q=[],h;if(!(b<d)){for(h=d;h<=b;h++){var n=c[h-1];var g=e.slice(h-d,h);var t=l(g,2,1);g=t[1];var m=t[0];t=(g+m)/2;a.push([n,g,t,m]);r.push(n);q.push([g,t,m])}return{values:a,xData:r,yData:q}}}}));""});u(a,"indicators/price-envelopes.src.js",
[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,k){var h=k.isArray,l=a.merge,e=a.seriesTypes.sma;a.seriesType("priceenvelopes","sma",{marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}},
{nameComponents:["period","topBand","bottomBand"],nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x","y","top","bottom"],pointValKey:"middle",init:function(){e.prototype.init.apply(this,arguments);this.options=l({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},toYData:function(d){return[d.top,d.middle,d.bottom]},translate:function(){var d=this,c=["plotTop","plotMiddle","plotBottom"];e.prototype.translate.apply(d);
d.points.forEach(function(b){[b.top,b.middle,b.bottom].forEach(function(e,a){null!==e&&(b[c[a]]=d.yAxis.toPixels(e,!0))})})},drawGraph:function(){for(var d=this,c=d.points,b=c.length,a=d.options,h=d.graph,q={options:{gapSize:a.gapSize}},k=[[],[]],n;b--;)n=c[b],k[0].push({plotX:n.plotX,plotY:n.plotTop,isNull:n.isNull}),k[1].push({plotX:n.plotX,plotY:n.plotBottom,isNull:n.isNull});["topLine","bottomLine"].forEach(function(b,c){d.points=k[c];d.options=l(a[b].styles,q);d.graph=d["graph"+b];e.prototype.drawGraph.call(d);
d["graph"+b]=d.graph});d.points=c;d.options=a;d.graph=h;e.prototype.drawGraph.call(d)},getValues:function(d,c){var b=c.period,a=c.topBand,l=c.bottomBand,q=d.xData,k=(d=d.yData)?d.length:0,n=[],g=[],t=[],m;if(!(q.length<b)&&h(d[0])&&4===d[0].length){for(m=b;m<=k;m++){var z=q.slice(m-b,m);var v=d.slice(m-b,m);v=e.prototype.getValues.call(this,{xData:z,yData:v},c);z=v.xData[0];v=v.yData[0];var p=v*(1+a);var A=v*(1-l);n.push([z,p,v,A]);g.push(z);t.push([p,v,A])}return{values:n,xData:g,yData:t}}}});""});
u(a,"indicators/psar.src.js",[a["parts/Globals.js"]],function(a){a.seriesType("psar","sma",{lineWidth:0,marker:{enabled:!0},states:{hover:{lineWidthPlus:0}},params:{initialAccelerationFactor:.02,maxAccelerationFactor:.2,increment:.02,index:2,decimals:4}},{nameComponents:!1,getValues:function(a,h){var l=a.xData;a=a.yData;var e=a[0][1],d=h.maxAccelerationFactor,c=h.increment,b=h.initialAccelerationFactor,f=a[0][2],r=h.decimals,q=h.index,k=[],n=[],g=[],t=1,m;if(!(q>=a.length)){for(m=0;m<q;m++)e=Math.max(a[m][1],
e),f=Math.min(a[m][2],parseFloat(f.toFixed(r)));var z=a[m][1]>f?1:-1;h=h.initialAccelerationFactor;var v=h*(e-f);k.push([l[q],f]);n.push(l[q]);g.push(parseFloat(f.toFixed(r)));for(m=q+1;m<a.length;m++){q=a[m-1][2];var p=a[m-2][2];var A=a[m-1][1];var w=a[m-2][1];var E=a[m][1];var y=a[m][2];null!==p&&null!==w&&null!==q&&null!==A&&null!==E&&null!==y&&(f=z===t?1===z?f+v<Math.min(p,q)?f+v:Math.min(p,q):f+v>Math.max(w,A)?f+v:Math.max(w,A):e,q=1===z?E>e?E:e:y<e?y:e,E=1===t&&y>f||-1===t&&E>f?1:-1,t=E,v=q,
y=c,p=d,A=b,h=t===z?1===t&&v>e?h===p?p:parseFloat((h+y).toFixed(2)):-1===t&&v<e?h===p?p:parseFloat((h+y).toFixed(2)):h:A,e=q-f,v=h*e,k.push([l[m],parseFloat(f.toFixed(r))]),n.push(l[m]),g.push(parseFloat(f.toFixed(r))),t=z,z=E,e=q)}return{values:k,xData:n,yData:g}}}});""});u(a,"indicators/roc.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,k){var h=k.isArray;a=a.seriesType;a("roc","sma",{params:{index:3,period:9}},{nameBase:"Rate of Change",getValues:function(a,e){var d=e.period,
c=a.xData,b=(a=a.yData)?a.length:0,f=[],l=[],q=[],k=-1;if(!(c.length<=d)){h(a[0])&&(k=e.index);for(e=d;e<b;e++){var n=0>k?(n=a[e-d])?(a[e]-n)/n*100:null:(n=a[e-d][k])?(a[e][k]-n)/n*100:null;n=[c[e],n];f.push(n);l.push(n[0]);q.push(n[1])}return{values:f,xData:l,yData:q}}}});""});u(a,"indicators/rsi.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,k){var h=k.isArray;a.seriesType("rsi","sma",{params:{period:14,decimals:4}},{getValues:function(a,e){var d=e.period,c=a.xData,b=(a=a.yData)?
a.length:0;e=e.decimals;var f=1,l=[],q=[],k=[],n=0,g=0,t;if(!(c.length<d)&&h(a[0])&&4===a[0].length){for(;f<d;){var m=parseFloat((a[f][3]-a[f-1][3]).toFixed(e));0<m?n+=m:g+=Math.abs(m);f++}var z=parseFloat((n/(d-1)).toFixed(e));for(t=parseFloat((g/(d-1)).toFixed(e));f<b;f++)m=parseFloat((a[f][3]-a[f-1][3]).toFixed(e)),0<m?(n=m,g=0):(n=0,g=Math.abs(m)),z=parseFloat(((z*(d-1)+n)/d).toFixed(e)),t=parseFloat(((t*(d-1)+g)/d).toFixed(e)),n=0===t?100:0===z?0:parseFloat((100-100/(1+z/t)).toFixed(e)),l.push([c[f],
n]),q.push(c[f]),k.push(n);return{values:l,xData:q,yData:k}}}});""});u(a,"indicators/stochastic.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"],a["mixins/reduce-array.js"],a["mixins/multipe-lines.js"]],function(a,k,p,l){var e=k.isArray,d=a.merge,c=a.seriesTypes.sma,b=p.getArrayExtremes;a.seriesType("stochastic","sma",{params:{periods:[14,3]},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>%K: {point.y}<br/>%D: {point.smoothed}<br/>'},
smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}},a.merge(l,{nameComponents:["periods"],nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x","y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"],init:function(){c.prototype.init.apply(this,arguments);this.options=d({smoothedLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(d,a){var f=a.periods[0];a=a.periods[1];var l=d.xData,h=(d=d.yData)?d.length:0,g=[],
r=[],m=[],k=null,v;if(!(h<f)&&e(d[0])&&4===d[0].length){for(v=f-1;v<h;v++){var p=d.slice(v-f+1,v+1);var A=b(p,2,1);var w=A[0];p=d[v][3]-w;w=A[1]-w;p=p/w*100;r.push(l[v]);m.push([p,null]);v>=f-1+(a-1)&&(k=c.prototype.getValues.call(this,{xData:r.slice(-a),yData:m.slice(-a)},{period:a}),k=k.yData[0]);g.push([l[v],p,k]);m[m.length-1][1]=k}return{values:g,xData:r,yData:m}}}}));""});u(a,"indicators/slow-stochastic.src.js",[a["parts/Globals.js"],a["mixins/indicator-required.js"]],function(a,k){var h=a.seriesTypes;
a.seriesType("slowstochastic","stochastic",{params:{periods:[14,3,3]}},{nameBase:"Slow Stochastic",init:function(){var l=arguments,e=this;k.isParentLoaded(a.seriesTypes.stochastic,"stochastic",e.type,function(d){d.prototype.init.apply(e,l)})},getValues:function(a,e){var d=e.periods,c=h.stochastic.prototype.getValues.call(this,a,e);a={values:[],xData:[],yData:[]};e=0;if(c){a.xData=c.xData.slice(d[1]-1);c=c.yData.slice(d[1]-1);var b=h.sma.prototype.getValues.call(this,{xData:a.xData,yData:c},{index:1,
period:d[2]});if(b){for(var f=a.xData.length;e<f;e++)a.yData[e]=[c[e][1],b.yData[e-d[2]+1]||null],a.values[e]=[a.xData[e],c[e][1],b.yData[e-d[2]+1]||null];return a}}}});""});u(a,"indicators/supertrend.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,k){function h(b,c,d){return{index:c,close:b.yData[c][d],x:b.xData[c]}}var l=k.correctFloat,e=k.isArray,d=k.objectEach,c=a.seriesTypes.atr,b=a.seriesTypes.sma,f=a.merge;a.seriesType("supertrend","sma",{params:{multiplier:3,period:10},
risingTrendColor:"#06B535",fallingTrendColor:"#F21313",changeTrendLine:{styles:{lineWidth:1,lineColor:"#333333",dashStyle:"LongDash"}}},{nameBase:"Supertrend",nameComponents:["multiplier","period"],requiredIndicators:["atr"],init:function(){b.prototype.init.apply(this,arguments);var c=this.options;c.cropThreshold=this.linkedParent.options.cropThreshold-(c.params.period-1)},drawGraph:function(){var c=this,a=c.options,e=c.linkedParent,n=e?e.points:[],g=c.points,l=c.graph,m=g.length,k=n.length-m;k=0<
k?k:0;for(var v={options:{gapSize:a.gapSize}},p={top:[],bottom:[],intersect:[]},A={top:{styles:{lineWidth:a.lineWidth,lineColor:a.fallingTrendColor||a.color,dashStyle:a.dashStyle}},bottom:{styles:{lineWidth:a.lineWidth,lineColor:a.risingTrendColor||a.color,dashStyle:a.dashStyle}},intersect:a.changeTrendLine},w,E,y,u,C,H,B,G;m--;)w=g[m],E=g[m-1],y=n[m-1+k],u=n[m-2+k],C=n[m+k],H=n[m+k+1],B=w.options.color,G={x:w.x,plotX:w.plotX,plotY:w.plotY,isNull:!1},!u&&y&&e.yData[y.index-1]&&(u=h(e,y.index-1,3)),
!H&&C&&e.yData[C.index+1]&&(H=h(e,C.index+1,3)),!y&&u&&e.yData[u.index+1]?y=h(e,u.index+1,3):!y&&C&&e.yData[C.index-1]&&(y=h(e,C.index-1,3)),w&&y&&C&&u&&w.x!==y.x&&(w.x===C.x?(u=y,y=C):w.x===u.x?(y=u,u={close:e.yData[y.index-1][3],x:e.xData[y.index-1]}):H&&w.x===H.x&&(y=H,u=C)),E&&u&&y?(C={x:E.x,plotX:E.plotX,plotY:E.plotY,isNull:!1},w.y>=y.close&&E.y>=u.close?(w.color=B||a.fallingTrendColor||a.color,p.top.push(G)):w.y<y.close&&E.y<u.close?(w.color=B||a.risingTrendColor||a.color,p.bottom.push(G)):
(p.intersect.push(G),p.intersect.push(C),p.intersect.push(f(C,{isNull:!0})),w.y>=y.close&&E.y<u.close?(w.color=B||a.fallingTrendColor||a.color,E.color=B||a.risingTrendColor||a.color,p.top.push(G),p.top.push(f(C,{isNull:!0}))):w.y<y.close&&E.y>=u.close&&(w.color=B||a.risingTrendColor||a.color,E.color=B||a.fallingTrendColor||a.color,p.bottom.push(G),p.bottom.push(f(C,{isNull:!0}))))):y&&(w.y>=y.close?(w.color=B||a.fallingTrendColor||a.color,p.top.push(G)):(w.color=B||a.risingTrendColor||a.color,p.bottom.push(G)));
d(p,function(d,a){c.points=d;c.options=f(A[a].styles,v);c.graph=c["graph"+a+"Line"];b.prototype.drawGraph.call(c);c["graph"+a+"Line"]=c.graph});c.points=g;c.options=a;c.graph=l},getValues:function(b,d){var a=d.period;d=d.multiplier;var f=b.xData,g=b.yData,h=[],m=[],k=[],q=0===a?0:a-1,r=[],p=[],w;if(!(f.length<=a||!e(g[0])||4!==g[0].length||0>a)){b=c.prototype.getValues.call(this,b,{period:a}).yData;for(w=0;w<b.length;w++){var u=g[q+w];var y=g[q+w-1]||[];var F=r[w-1];var C=p[w-1];var H=k[w-1];0===
w&&(F=C=H=0);a=l((u[1]+u[2])/2+d*b[w]);var B=l((u[1]+u[2])/2-d*b[w]);r[w]=a<F||y[3]>F?a:F;p[w]=B>C||y[3]<C?B:C;if(H===F&&u[3]<r[w]||H===C&&u[3]<p[w])var G=r[w];else if(H===F&&u[3]>r[w]||H===C&&u[3]>p[w])G=p[w];h.push([f[q+w],G]);m.push(f[q+w]);k.push(G)}return{values:h,xData:m,yData:k}}}});""});u(a,"indicators/volume-by-price.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,k){var h=k.animObject,l=k.arrayMax,e=k.arrayMin,d=k.correctFloat,c=k.extend,b=k.isArray,f=Math.abs;k=a.noop;
var r=a.addEvent,q=a.seriesType,x=a.seriesTypes.column.prototype;q("vbp","sma",{params:{ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",
padding:0,style:{fontSize:"7px"},verticalAlign:"top"}},{nameBase:"Volume by Price",bindTo:{series:!1,eventName:"afterSetExtremes"},calculateOn:"render",markerAttribs:k,drawGraph:k,getColumnMetrics:x.getColumnMetrics,crispCol:x.crispCol,init:function(b){a.seriesTypes.sma.prototype.init.apply(this,arguments);var c=this.options.params;var d=this.linkedParent;c=b.get(c.volumeSeriesID);this.addCustomEvents(d,c);return this},addCustomEvents:function(b,c){function d(){a.chart.redraw();a.setData([]);a.zoneStarts=
[];a.zoneLinesSVG&&(a.zoneLinesSVG.destroy(),delete a.zoneLinesSVG)}var a=this;a.dataEventsToUnbind.push(r(b,"remove",function(){d()}));c&&a.dataEventsToUnbind.push(r(c,"remove",function(){d()}));return a},animate:function(b){var d=this,e={};a.svg&&!b&&(e.translateX=d.yAxis.pos,d.group.animate(e,c(h(d.options.animation),{step:function(b,c){d.group.attr({scaleX:Math.max(.001,c.pos)})}})),d.animate=null)},drawPoints:function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),x.drawPoints.apply(this,
arguments),this.posNegVolume(!1,!1));x.drawPoints.apply(this,arguments)},posNegVolume:function(b,c){var d=c?["positive","negative"]:["negative","positive"],a=this.options.volumeDivision,e=this.points.length,f=[],g=[],h=0,l;b?(this.posWidths=f,this.negWidths=g):(f=this.posWidths,g=this.negWidths);for(;h<e;h++){var n=this.points[h];n[d[0]+"Graphic"]=n.graphic;n.graphic=n[d[1]+"Graphic"];if(b){var k=n.shapeArgs.width;var q=this.priceZones[h];(l=q.wholeVolumeData)?(f.push(k/l*q.positiveVolumeData),g.push(k/
l*q.negativeVolumeData)):(f.push(0),g.push(0))}n.color=c?a.styles.positiveColor:a.styles.negativeColor;n.shapeArgs.width=c?this.posWidths[h]:this.negWidths[h];n.shapeArgs.x=c?n.shapeArgs.x:this.posWidths[h]}},translate:function(){var b=this,c=b.options,a=b.chart,e=b.yAxis,h=e.min,k=b.options.zoneLines,q=b.priceZones,r=0,p,u,y;x.translate.apply(b);var F=b.points;if(F.length){var C=.5>c.pointPadding?c.pointPadding:.1;c=b.volumeDataArray;var H=l(c);var B=a.plotWidth/2;var G=a.plotTop;var J=f(e.toPixels(h)-
e.toPixels(h+b.rangeStep));var M=f(e.toPixels(h)-e.toPixels(h+b.rangeStep));C&&(h=f(J*(1-2*C)),r=f((J-h)/2),J=f(h));F.forEach(function(c,a){u=c.barX=c.plotX=0;y=c.plotY=e.toPixels(q[a].start)-G-(e.reversed?J-M:J)-r;p=d(B*q[a].wholeVolumeData/H);c.pointWidth=p;c.shapeArgs=b.crispCol.apply(b,[u,y,p,J]);c.volumeNeg=q[a].negativeVolumeData;c.volumePos=q[a].positiveVolumeData;c.volumeAll=q[a].wholeVolumeData});k.enabled&&b.drawZones(a,e,b.zoneStarts,k.styles)}},getValues:function(c,d){var e=c.processedXData,
f=c.processedYData,g=this.chart,h=d.ranges,l=[],n=[],k=[],q;if(c.chart)if(q=g.get(d.volumeSeriesID))if((d=b(f[0]))&&4!==f[0].length)a.error("Type of "+c.name+" series is different than line, OHLC or candlestick.",!0,g);else return(this.priceZones=this.specifyZones(d,e,f,h,q)).forEach(function(b,c){l.push([b.x,b.end]);n.push(l[c][0]);k.push(l[c][1])}),{values:l,xData:n,yData:k};else a.error("Series "+d.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,g);else a.error("Base series not found! In case it has been removed, add a new one.",
!0,g)},specifyZones:function(b,c,a,f,h){if(b){var g=a.length;for(var m=a[0][3],n=m,k=1,q;k<g;k++)q=a[k][3],q<m&&(m=q),q>n&&(n=q);g={min:m,max:n}}else g=!1;g=(m=g)?m.min:e(a);q=m?m.max:l(a);m=this.zoneStarts=[];n=[];var r=0;k=1;if(!g||!q)return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG.destroy()),[];var t=this.rangeStep=d(q-g)/f;for(m.push(g);r<f-1;r++)m.push(d(m[r]+t));m.push(q);for(f=m.length;k<f;k++)n.push({index:k-1,x:c[0],start:m[k-1],end:m[k]});return this.volumePerZone(b,
n,h,c,a)},volumePerZone:function(b,c,a,d,e){var g=this,h=a.processedXData,l=a.processedYData,m=c.length-1,k=e.length;a=l.length;var q,n,r,t,p;f(k-a)&&(d[0]!==h[0]&&l.unshift(0),d[k-1]!==h[a-1]&&l.push(0));g.volumeDataArray=[];c.forEach(function(c){c.wholeVolumeData=0;c.positiveVolumeData=0;for(p=c.negativeVolumeData=0;p<k;p++)r=n=!1,t=b?e[p][3]:e[p],q=p?b?e[p-1][3]:e[p-1]:t,t<=c.start&&0===c.index&&(n=!0),t>=c.end&&c.index===m&&(r=!0),(t>c.start||n)&&(t<c.end||r)&&(c.wholeVolumeData+=l[p],q>t?c.negativeVolumeData+=
l[p]:c.positiveVolumeData+=l[p]);g.volumeDataArray.push(c.wholeVolumeData)});return c},drawZones:function(b,c,a,d){var e=b.renderer,f=this.zoneLinesSVG,g=[],h=b.plotWidth,l=b.plotTop,m;a.forEach(function(a){m=c.toPixels(a)-l;g=g.concat(b.renderer.crispLine(["M",0,m,"L",h,m],d.lineWidth))});f?f.animate({d:g}):f=this.zoneLinesSVG=e.path(g).attr({"stroke-width":d.lineWidth,stroke:d.color,dashstyle:d.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)}},{destroy:function(){this.negativeGraphic&&(this.negativeGraphic=
this.negativeGraphic.destroy());return a.Point.prototype.destroy.apply(this,arguments)}});""});u(a,"indicators/vwap.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,k){var h=k.isArray;k=a.seriesType;k("vwap","sma",{params:{period:30,volumeSeriesID:"volume"}},{getValues:function(l,e){var d=l.chart,c=l.xData;l=l.yData;var b=e.period,f=!0,k;if(k=d.get(e.volumeSeriesID))return h(l[0])||(f=!1),this.calculateVWAPValues(f,c,l,k,b);a.error("Series "+e.volumeSeriesID+" not found! Check `volumeSeriesID`.",
!0,d)},calculateVWAPValues:function(a,e,d,c,b){var f=c.yData,h=c.xData.length,l=e.length;c=[];var k=[],n=[],g=[],t=[],m;h=l<=h?l:h;for(m=l=0;l<h;l++){var p=a?(d[l][1]+d[l][2]+d[l][3])/3:d[l];p*=f[l];p=m?c[l-1]+p:p;var v=m?k[l-1]+f[l]:f[l];c.push(p);k.push(v);t.push([e[l],p/v]);n.push(t[l][0]);g.push(t[l][1]);m++;m===b&&(m=0)}return{values:t,xData:n,yData:g}}});""});u(a,"indicators/williams-r.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"],a["mixins/reduce-array.js"]],function(a,k,p){var l=
k.isArray,e=p.getArrayExtremes;a.seriesType("williamsr","sma",{params:{period:14}},{nameBase:"Williams %R",getValues:function(a,c){c=c.period;var b=a.xData,d=(a=a.yData)?a.length:0,h=[],k=[],p=[],n;if(!(b.length<c)&&l(a[0])&&4===a[0].length){for(n=c-1;n<d;n++){var g=a.slice(n-c+1,n+1);var t=e(g,2,1);g=t[0];t=t[1];var m=a[n][3];g=(t-m)/(t-g)*-100;b[n]&&(h.push([b[n],g]),k.push(b[n]),p.push(g))}return{values:h,xData:k,yData:p}}}});""});u(a,"indicators/wma.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],
function(a,k){function h(a,c){c*=(c+1)/2;return a.reduce(function(b,c,a){return[null,b[1]+c[1]*(a+1)]})[1]/c}function l(a,c,b,e){b=h(a,a.length);c=c[e-1];a.shift();return[c,b]}var e=k.isArray;a=a.seriesType;a("wma","sma",{params:{index:3,period:9}},{getValues:function(a,c){var b=c.period,d=a.xData,h=(a=a.yData)?a.length:0,k=1,p=d[0],n=a[0],g=[],t=[],m=[],u=-1;if(!(d.length<b)){e(a[0])&&(u=c.index,n=a[0][u]);for(c=[[p,n]];k!==b;)c.push([d[k],0>u?a[k]:a[k][u]]),k++;for(b=k;b<h;b++)k=l(c,d,a,b),g.push(k),
t.push(k[0]),m.push(k[1]),c.push([d[b],0>u?a[b]:a[b][u]]);k=l(c,d,a,b);g.push(k);t.push(k[0]);m.push(k[1]);return{values:g,xData:t,yData:m}}}});""});u(a,"indicators/zigzag.src.js",[a["parts/Globals.js"]],function(a){a=a.seriesType;a("zigzag","sma",{params:{lowIndex:2,highIndex:1,deviation:1}},{nameComponents:["deviation"],nameSuffixes:["%"],nameBase:"Zig Zag",getValues:function(a,h){var l=h.lowIndex,e=h.highIndex,d=h.deviation/100;h=1+d;var c=1-d;d=a.xData;var b=a.yData;a=b?b.length:0;var f=[],k=
[],q=[],p,n,g=!1,t=!1;if(!(!d||1>=d.length||a&&(void 0===b[0][l]||void 0===b[0][e]))){var m=b[0][l];var u=b[0][e];for(p=1;p<a;p++){if(b[p][l]<=u*c){f.push([d[0],u]);var v=[d[p],b[p][l]];g=n=!0}else b[p][e]>=m*h&&(f.push([d[0],m]),v=[d[p],b[p][e]],n=!1,g=!0);if(g){k.push(f[0][0]);q.push(f[0][1]);var K=p++;p=a}}for(p=K;p<a;p++)n?(b[p][l]<=v[1]&&(v=[d[p],b[p][l]]),b[p][e]>=v[1]*h&&(t=e)):(b[p][e]>=v[1]&&(v=[d[p],b[p][e]]),b[p][l]<=v[1]*c&&(t=l)),!1!==t&&(f.push(v),k.push(v[0]),q.push(v[1]),v=[d[p],b[p][t]],
n=!n,t=!1);l=f.length;0!==l&&f[l-1][0]<d[a-1]&&(f.push(v),k.push(v[0]),q.push(v[1]));return{values:f,xData:k,yData:q}}}});""});u(a,"indicators/regressions.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,k){var h=k.isArray;a=a.seriesType;a("linearRegression","sma",{params:{xAxisUnit:void 0},tooltip:{valueDecimals:4}},{nameBase:"Linear Regression Indicator",getRegressionLineParameters:function(a,e){var d=this.options.params.index,c=function(a,b){return h(a)?a[b]:a},b=a.reduce(function(a,
b){return b+a},0),f=e.reduce(function(a,b){return c(b,d)+a},0);b/=a.length;f/=e.length;var l=0,k=0,p;for(p=0;p<a.length;p++){var n=a[p]-b;var g=c(e[p],d)-f;l+=n*g;k+=Math.pow(n,2)}a=k?l/k:0;return{slope:a,intercept:f-a*b}},getEndPointY:function(a,e){return a.slope*e+a.intercept},transformXData:function(a,e){var d=a[0];return a.map(function(a){return(a-d)/e})},findClosestDistance:function(a){var e,d;for(d=1;d<a.length-1;d++){var c=a[d]-a[d-1];0<c&&("undefined"===typeof e||c<e)&&(e=c)}return e},getValues:function(a,
e){var d=a.xData;a=a.yData;e=e.period;var c,b={xData:[],yData:[],values:[]},f=this.options.params.xAxisUnit||this.findClosestDistance(d);for(c=e-1;c<=d.length-1;c++){var h=c-e+1;var k=c+1;var l=d[c];var n=d.slice(h,k);h=a.slice(h,k);k=this.transformXData(n,f);n=this.getRegressionLineParameters(k,h);h=this.getEndPointY(n,k[k.length-1]);b.values.push({regressionLineParameters:n,x:l,y:h});b.xData.push(l);b.yData.push(h)}return b}});a("linearRegressionSlope","linearRegression",{},{nameBase:"Linear Regression Slope Indicator",
getEndPointY:function(a){return a.slope}});a("linearRegressionIntercept","linearRegression",{},{nameBase:"Linear Regression Intercept Indicator",getEndPointY:function(a){return a.intercept}});a("linearRegressionAngle","linearRegression",{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span>{series.name}: <b>{point.y}\u00b0</b><br/>'}},{nameBase:"Linear Regression Angle Indicator",slopeToAngle:function(a){return 180/Math.PI*Math.atan(a)},getEndPointY:function(a){return this.slopeToAngle(a.slope)}});
""});u(a,"indicators/acceleration-bands.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"],a["mixins/multipe-lines.js"]],function(a,k,p){var h=k.correctFloat,e=a.seriesTypes.sma;k=a.merge;a.seriesType("abands","sma",{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},bottomLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}},k(p,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Acceleration Bands",nameComponents:["period","factor"],
linesApiNames:["topLine","bottomLine"],getValues:function(a,c){var b=c.period,d=c.factor;c=c.index;var k=a.xData,l=(a=a.yData)?a.length:0,p=[],n=[],g=[],t=[],m=[],u;if(!(l<b)){for(u=0;u<=l;u++){if(u<l){var v=a[u][2];var K=a[u][1];var A=d;v=h(K-v)/(h(K+v)/2)*1E3*A;p.push(a[u][1]*h(1+2*v));n.push(a[u][2]*h(1-2*v))}if(u>=b){v=k.slice(u-b,u);var w=a.slice(u-b,u);A=e.prototype.getValues.call(this,{xData:v,yData:p.slice(u-b,u)},{period:b});K=e.prototype.getValues.call(this,{xData:v,yData:n.slice(u-b,u)},
{period:b});w=e.prototype.getValues.call(this,{xData:v,yData:w},{period:b,index:c});v=w.xData[0];A=A.yData[0];K=K.yData[0];w=w.yData[0];g.push([v,A,w,K]);t.push(v);m.push([A,w,K])}}return{values:g,xData:t,yData:m}}}}));""});u(a,"indicators/trendline.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,k){var h=k.isArray;a=a.seriesType;a("trendline","sma",{params:{index:3}},{nameBase:"Trendline",nameComponents:!1,getValues:function(a,e){var d=a.xData,c=a.yData;a=[];var b=[],f=[],k=0,
l=0,p=0,n=0,g=d.length,t=e.index;for(e=0;e<g;e++){var m=d[e];var u=h(c[e])?c[e][t]:c[e];k+=m;l+=u;p+=m*u;n+=m*m}c=(g*p-k*l)/(g*n-k*k);isNaN(c)&&(c=0);k=(l-c*k)/g;for(e=0;e<g;e++)m=d[e],u=c*m+k,a[e]=[m,u],b[e]=m,f[e]=u;return{xData:b,yData:f,values:a}}});""});u(a,"masters/indicators/indicators-all.src.js",[],function(){})});
//# sourceMappingURL=indicators-all.js.map