/*
 Highstock JS v8.0.0 (2019-12-10)

 Indicator series type for Highstock

 (c) 2010-2019 Pawe Dalek

 License: www.highcharts.com/license
*/
(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/indicators/volume-by-price",["highcharts","highcharts/modules/stock"],function(m){b(m);b.Highcharts=m;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function m(b,h,m,x){b.hasOwnProperty(h)||(b[h]=x.apply(null,m))}b=b?b._modules:{};m(b,"indicators/volume-by-price.src.js",[b["parts/Globals.js"],b["parts/Utilities.js"]],function(b,
h){var m=h.animObject,x=h.arrayMax,A=h.arrayMin,z=h.correctFloat,B=h.extend,C=h.isArray,u=Math.abs;h=b.noop;var y=b.addEvent,D=b.seriesType,w=b.seriesTypes.column.prototype;D("vbp","sma",{params:{ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,
dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},verticalAlign:"top"}},{nameBase:"Volume by Price",bindTo:{series:!1,eventName:"afterSetExtremes"},calculateOn:"render",markerAttribs:h,drawGraph:h,getColumnMetrics:w.getColumnMetrics,crispCol:w.crispCol,init:function(c){b.seriesTypes.sma.prototype.init.apply(this,arguments);var a=this.options.params;var f=this.linkedParent;a=c.get(a.volumeSeriesID);
this.addCustomEvents(f,a);return this},addCustomEvents:function(c,a){function f(){e.chart.redraw();e.setData([]);e.zoneStarts=[];e.zoneLinesSVG&&(e.zoneLinesSVG.destroy(),delete e.zoneLinesSVG)}var e=this;e.dataEventsToUnbind.push(y(c,"remove",function(){f()}));a&&e.dataEventsToUnbind.push(y(a,"remove",function(){f()}));return e},animate:function(c){var a=this,f={};b.svg&&!c&&(f.translateX=a.yAxis.pos,a.group.animate(f,B(m(a.options.animation),{step:function(c,f){a.group.attr({scaleX:Math.max(.001,
f.pos)})}})),a.animate=null)},drawPoints:function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),w.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));w.drawPoints.apply(this,arguments)},posNegVolume:function(c,a){var f=a?["positive","negative"]:["negative","positive"],e=this.options.volumeDivision,b=this.points.length,r=[],d=[],k=0,l;c?(this.posWidths=r,this.negWidths=d):(r=this.posWidths,d=this.negWidths);for(;k<b;k++){var g=this.points[k];g[f[0]+"Graphic"]=g.graphic;g.graphic=
g[f[1]+"Graphic"];if(c){var p=g.shapeArgs.width;var q=this.priceZones[k];(l=q.wholeVolumeData)?(r.push(p/l*q.positiveVolumeData),d.push(p/l*q.negativeVolumeData)):(r.push(0),d.push(0))}g.color=a?e.styles.positiveColor:e.styles.negativeColor;g.shapeArgs.width=a?this.posWidths[k]:this.negWidths[k];g.shapeArgs.x=a?g.shapeArgs.x:this.posWidths[k]}},translate:function(){var c=this,a=c.options,f=c.chart,e=c.yAxis,b=e.min,r=c.options.zoneLines,d=c.priceZones,k=0,l,g,p;w.translate.apply(c);var q=c.points;
if(q.length){var h=.5>a.pointPadding?a.pointPadding:.1;a=c.volumeDataArray;var m=x(a);var n=f.plotWidth/2;var E=f.plotTop;var v=u(e.toPixels(b)-e.toPixels(b+c.rangeStep));var y=u(e.toPixels(b)-e.toPixels(b+c.rangeStep));h&&(b=u(v*(1-2*h)),k=u((v-b)/2),v=u(b));q.forEach(function(b,a){g=b.barX=b.plotX=0;p=b.plotY=e.toPixels(d[a].start)-E-(e.reversed?v-y:v)-k;l=z(n*d[a].wholeVolumeData/m);b.pointWidth=l;b.shapeArgs=c.crispCol.apply(c,[g,p,l,v]);b.volumeNeg=d[a].negativeVolumeData;b.volumePos=d[a].positiveVolumeData;
b.volumeAll=d[a].wholeVolumeData});r.enabled&&c.drawZones(f,e,c.zoneStarts,r.styles)}},getValues:function(c,a){var f=c.processedXData,e=c.processedYData,h=this.chart,r=a.ranges,d=[],k=[],l=[],g;if(c.chart)if(g=h.get(a.volumeSeriesID))if((a=C(e[0]))&&4!==e[0].length)b.error("Type of "+c.name+" series is different than line, OHLC or candlestick.",!0,h);else return(this.priceZones=this.specifyZones(a,f,e,r,g)).forEach(function(b,a){d.push([b.x,b.end]);k.push(d[a][0]);l.push(d[a][1])}),{values:d,xData:k,
yData:l};else b.error("Series "+a.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,h);else b.error("Base series not found! In case it has been removed, add a new one.",!0,h)},specifyZones:function(b,a,f,e,h){if(b){var c=f.length;for(var d=f[0][3],k=d,l=1,g;l<c;l++)g=f[l][3],g<d&&(d=g),g>k&&(k=g);c={min:d,max:k}}else c=!1;c=(d=c)?d.min:A(f);g=d?d.max:x(f);d=this.zoneStarts=[];k=[];var p=0;l=1;if(!c||!g)return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG.destroy()),
[];var q=this.rangeStep=z(g-c)/e;for(d.push(c);p<e-1;p++)d.push(z(d[p]+q));d.push(g);for(e=d.length;l<e;l++)k.push({index:l-1,x:a[0],start:d[l-1],end:d[l]});return this.volumePerZone(b,k,h,a,f)},volumePerZone:function(b,a,f,e,h){var c=this,d=f.processedXData,k=f.processedYData,l=a.length-1,g=h.length;f=k.length;var p,q,m,t,n;u(g-f)&&(e[0]!==d[0]&&k.unshift(0),e[g-1]!==d[f-1]&&k.push(0));c.volumeDataArray=[];a.forEach(function(a){a.wholeVolumeData=0;a.positiveVolumeData=0;for(n=a.negativeVolumeData=
0;n<g;n++)m=q=!1,t=b?h[n][3]:h[n],p=n?b?h[n-1][3]:h[n-1]:t,t<=a.start&&0===a.index&&(q=!0),t>=a.end&&a.index===l&&(m=!0),(t>a.start||q)&&(t<a.end||m)&&(a.wholeVolumeData+=k[n],p>t?a.negativeVolumeData+=k[n]:a.positiveVolumeData+=k[n]);c.volumeDataArray.push(a.wholeVolumeData)});return a},drawZones:function(b,a,f,e){var c=b.renderer,h=this.zoneLinesSVG,d=[],k=b.plotWidth,l=b.plotTop,g;f.forEach(function(c){g=a.toPixels(c)-l;d=d.concat(b.renderer.crispLine(["M",0,g,"L",k,g],e.lineWidth))});h?h.animate({d:d}):
h=this.zoneLinesSVG=c.path(d).attr({"stroke-width":e.lineWidth,stroke:e.color,dashstyle:e.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)}},{destroy:function(){this.negativeGraphic&&(this.negativeGraphic=this.negativeGraphic.destroy());return b.Point.prototype.destroy.apply(this,arguments)}});""});m(b,"masters/indicators/volume-by-price.src.js",[],function(){})});
//# sourceMappingURL=volume-by-price.js.map